/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.PartP2PTunnel;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public class PartP2PGTCEPower
extends PartP2PTunnel<PartP2PGTCEPower> {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_gteu");
    private static final IEnergyContainer NULL_ENERGY_STORAGE = new NullEnergyStorage();
    private final IEnergyContainer inputHandler = new InputEnergyStorage();
    private final Queue<PartP2PGTCEPower> outputs = new ArrayDeque<PartP2PGTCEPower>();

    public PartP2PGTCEPower(ItemStack is) {
        super(is);
    }

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Override
    public void onTunnelNetworkChange() {
        this.getHost().notifyNeighbors();
    }

    private IEnergyContainer getAttachedEnergyStorage() {
        TileEntity self;
        TileEntity te;
        if (this.isActive() && (te = (self = this.getTile()).func_145831_w().func_175625_s(self.func_174877_v().func_177972_a(this.getSide().getFacing()))) != null && te.hasCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, this.getSide().getOpposite().getFacing())) {
            return (IEnergyContainer)te.getCapability(GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER, this.getSide().getOpposite().getFacing());
        }
        return NULL_ENERGY_STORAGE;
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability) {
        if (!this.isOutput() && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            return true;
        }
        return super.hasCapability(capability);
    }

    @Override
    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability) {
        if (capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            if (this.isOutput()) {
                return null;
            }
            return (T)this.inputHandler;
        }
        return super.getCapability(capability);
    }

    static class NullEnergyStorage
    implements IEnergyContainer {
        NullEnergyStorage() {
        }

        public long acceptEnergyFromNetwork(EnumFacing enumFacing, long l, long l1) {
            return 0L;
        }

        public boolean inputsEnergy(EnumFacing enumFacing) {
            return false;
        }

        public long changeEnergy(long l) {
            return 0L;
        }

        public long getEnergyStored() {
            return 0L;
        }

        public long getEnergyCapacity() {
            return 0L;
        }

        public long getInputAmperage() {
            return 0L;
        }

        public long getInputVoltage() {
            return 0L;
        }
    }

    class InputEnergyStorage
    implements IEnergyContainer {
        InputEnergyStorage() {
        }

        public long getEnergyCanBeInserted() {
            long canInsert = 0L;
            if (PartP2PGTCEPower.this.outputs.isEmpty()) {
                try {
                    for (PartP2PGTCEPower o : PartP2PGTCEPower.this.getOutputs()) {
                        PartP2PGTCEPower.this.outputs.add(o);
                    }
                }
                catch (GridAccessException e) {
                    e.printStackTrace();
                }
            }
            while (!PartP2PGTCEPower.this.outputs.isEmpty()) {
                PartP2PGTCEPower target = (PartP2PGTCEPower)PartP2PGTCEPower.this.outputs.poll();
                IEnergyContainer output = target.getAttachedEnergyStorage();
                if (output == this) {
                    return 0L;
                }
                if (output == null || output.getEnergyCanBeInserted() <= 0L) continue;
                canInsert += output.getEnergyCanBeInserted();
            }
            return canInsert;
        }

        public long acceptEnergyFromNetwork(EnumFacing facing, long voltage, long amperage) {
            long amperesUsed;
            block5: {
                PartP2PGTCEPower target;
                IEnergyContainer output;
                amperesUsed = 0L;
                if (PartP2PGTCEPower.this.outputs.isEmpty()) {
                    try {
                        for (PartP2PGTCEPower o : PartP2PGTCEPower.this.getOutputs()) {
                            PartP2PGTCEPower.this.outputs.add(o);
                        }
                    }
                    catch (GridAccessException e) {
                        e.printStackTrace();
                    }
                }
                if ((voltage = (long)((double)voltage * 0.95)) <= 0L) break block5;
                while (!(PartP2PGTCEPower.this.outputs.isEmpty() || (output = (target = (PartP2PGTCEPower)PartP2PGTCEPower.this.outputs.poll()).getAttachedEnergyStorage()) != null && output.inputsEnergy(facing) && output.getEnergyCanBeInserted() > 0L && amperage >= (amperesUsed += output.acceptEnergyFromNetwork(facing, voltage, amperage - amperesUsed)))) {
                }
            }
            return amperesUsed;
        }

        public boolean inputsEnergy(EnumFacing enumFacing) {
            return true;
        }

        public long changeEnergy(long l) {
            return 0L;
        }

        public long getEnergyStored() {
            return 0L;
        }

        public long getEnergyCapacity() {
            return 0L;
        }

        public long getInputAmperage() {
            return 0L;
        }

        public long getInputVoltage() {
            return 0L;
        }
    }
}

