/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.reporting;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.parts.IPartModel;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IFluidStorageChannel;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.AELog;
import appeng.fluids.util.AEFluidStack;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.PlayerSource;
import appeng.parts.PartModel;
import appeng.parts.reporting.AbstractPartMonitor;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;

public class PartConversionMonitor
extends AbstractPartMonitor {
    @PartModels
    public static final ResourceLocation MODEL_OFF = new ResourceLocation("appliedenergistics2", "part/conversion_monitor_off");
    @PartModels
    public static final ResourceLocation MODEL_ON = new ResourceLocation("appliedenergistics2", "part/conversion_monitor_on");
    @PartModels
    public static final ResourceLocation MODEL_LOCKED_OFF = new ResourceLocation("appliedenergistics2", "part/conversion_monitor_locked_off");
    @PartModels
    public static final ResourceLocation MODEL_LOCKED_ON = new ResourceLocation("appliedenergistics2", "part/conversion_monitor_locked_on");
    public static final IPartModel MODELS_OFF = new PartModel(MODEL_BASE, MODEL_OFF, MODEL_STATUS_OFF);
    public static final IPartModel MODELS_ON = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_ON);
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(MODEL_BASE, MODEL_ON, MODEL_STATUS_HAS_CHANNEL);
    public static final IPartModel MODELS_LOCKED_OFF = new PartModel(MODEL_BASE, MODEL_LOCKED_OFF, MODEL_STATUS_OFF);
    public static final IPartModel MODELS_LOCKED_ON = new PartModel(MODEL_BASE, MODEL_LOCKED_ON, MODEL_STATUS_ON);
    public static final IPartModel MODELS_LOCKED_HAS_CHANNEL = new PartModel(MODEL_BASE, MODEL_LOCKED_ON, MODEL_STATUS_HAS_CHANNEL);

    public PartConversionMonitor(ItemStack is) {
        super(is);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        ItemStack eq = player.func_184586_b(hand);
        FluidStack fluidInTank = null;
        if (eq.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)eq.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            fluidInTank = fluidHandlerItem.drain(Integer.MAX_VALUE, false);
        }
        if (this.isLocked()) {
            if (eq.func_190926_b()) {
                this.insertItem(player, hand, true);
            } else {
                if (Platform.isWrench(player, eq, this.getLocation().getPos()) && (this.getDisplayed() == null || !this.getDisplayed().equals(eq))) {
                    return super.onPartActivate(player, hand, pos);
                }
                if (fluidInTank != null && fluidInTank.amount > 0) {
                    if (this.getDisplayed() != null && this.getDisplayed().equals(AEFluidStack.fromFluidStack(fluidInTank))) {
                        this.drainFluidContainer(player, hand);
                    }
                } else {
                    this.insertItem(player, hand, false);
                }
            }
        }
        if (fluidInTank != null && fluidInTank.amount > 0) {
            if (this.getDisplayed() instanceof IAEItemStack || this.getDisplayed() == null) {
                return super.onPartActivate(player, hand, pos);
            }
            if (!((IAEFluidStack)this.getDisplayed()).equals(AEFluidStack.fromFluidStack(fluidInTank))) return super.onPartActivate(player, hand, pos);
            this.drainFluidContainer(player, hand);
            return super.onPartActivate(player, hand, pos);
        } else {
            if (this.getDisplayed() == null || !this.getDisplayed().equals(player.func_184586_b(hand))) return super.onPartActivate(player, hand, pos);
            this.insertItem(player, hand, false);
        }
        return super.onPartActivate(player, hand, pos);
    }

    @Override
    public boolean onClicked(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        if (this.getDisplayed() != null && this.getDisplayed() instanceof IAEItemStack) {
            this.extractItem(player, ((IAEItemStack)this.getDisplayed()).getDefinition().func_77976_d());
        } else if (this.getDisplayed() != null && this.getDisplayed() instanceof IAEFluidStack) {
            this.fillFluidContainer(player, hand);
        }
        return true;
    }

    @Override
    public boolean onShiftClicked(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (Platform.isClient()) {
            return true;
        }
        if (!this.getProxy().isActive()) {
            return false;
        }
        if (!Platform.hasPermissions(this.getLocation(), player)) {
            return false;
        }
        if (this.getDisplayed() != null) {
            this.extractItem(player, 1);
        }
        return true;
    }

    private void insertItem(EntityPlayer player, EnumHand hand, boolean allItems) {
        try {
            IEnergyGrid energy = this.getProxy().getEnergy();
            IMEMonitor<IAEItemStack> cell = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            if (allItems) {
                if (this.getDisplayed() != null && this.getDisplayed() instanceof IAEItemStack) {
                    IAEItemStack input = (IAEItemStack)this.getDisplayed().copy();
                    PlayerMainInvWrapper inv = new PlayerMainInvWrapper(player.field_71071_by);
                    for (int x = 0; x < inv.getSlots(); ++x) {
                        ItemStack canExtract;
                        ItemStack targetStack = inv.getStackInSlot(x);
                        if (!input.equals(targetStack) || (canExtract = inv.extractItem(x, targetStack.func_190916_E(), true)).func_190926_b()) continue;
                        input.setStackSize(canExtract.func_190916_E());
                        IAEItemStack failedToInsert = Platform.poweredInsert(energy, cell, input, new PlayerSource(player, this));
                        inv.extractItem(x, failedToInsert == null ? canExtract.func_190916_E() : canExtract.func_190916_E() - (int)failedToInsert.getStackSize(), false);
                    }
                }
            } else {
                AEItemStack input = AEItemStack.fromItemStack(player.func_184586_b(hand));
                IAEItemStack failedToInsert = Platform.poweredInsert(energy, cell, input, new PlayerSource(player, this));
                player.func_184611_a(hand, failedToInsert == null ? ItemStack.field_190927_a : failedToInsert.createItemStack());
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    private void extractItem(EntityPlayer player, int count) {
        if (!(this.getDisplayed() instanceof IAEItemStack)) {
            return;
        }
        IAEItemStack input = (IAEItemStack)this.getDisplayed().copy();
        if (input != null) {
            try {
                if (!this.getProxy().isActive()) {
                    return;
                }
                IEnergyGrid energy = this.getProxy().getEnergy();
                IMEMonitor<IAEItemStack> cell = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
                input.setStackSize(count);
                IAEItemStack retrieved = Platform.poweredExtraction(energy, cell, input, new PlayerSource(player, this));
                if (retrieved != null) {
                    ItemStack newItems = retrieved.createItemStack();
                    InventoryAdaptor adaptor = InventoryAdaptor.getAdaptor(player);
                    newItems = adaptor.addItems(newItems);
                    if (!newItems.func_190926_b()) {
                        TileEntity te = this.getTile();
                        List<ItemStack> list = Collections.singletonList(newItems);
                        Platform.spawnDrops(player.field_70170_p, te.func_174877_v().func_177972_a(this.getSide().getFacing()), list);
                    }
                    if (player.field_71070_bA != null) {
                        player.field_71070_bA.func_75142_b();
                    }
                }
            }
            catch (GridAccessException gridAccessException) {
                // empty catch block
            }
        }
    }

    private void drainFluidContainer(EntityPlayer player, EnumHand hand) {
        try {
            IMEMonitor<IAEFluidStack> cell;
            ItemStack held = player.func_184586_b(hand);
            if (held.func_190916_E() != 1) {
                return;
            }
            IFluidHandlerItem fh = FluidUtil.getFluidHandler((ItemStack)held);
            if (fh == null) {
                return;
            }
            FluidStack extract = fh.drain(Integer.MAX_VALUE, false);
            if (extract == null || extract.amount < 1) {
                return;
            }
            IEnergyGrid energy = this.getProxy().getEnergy();
            IAEFluidStack notStorable = Platform.poweredInsert(energy, cell = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class)), AEFluidStack.fromFluidStack(extract), new PlayerSource(player, this), Actionable.SIMULATE);
            if (notStorable != null && notStorable.getStackSize() > 0L) {
                int toStore = (int)((long)extract.amount - notStorable.getStackSize());
                FluidStack storable = fh.drain(toStore, false);
                if (storable == null || storable.amount == 0) {
                    return;
                }
                extract.amount = storable.amount;
            }
            FluidStack drained = fh.drain(extract, true);
            extract.amount = drained.amount;
            IAEFluidStack notInserted = Platform.poweredInsert(energy, cell, AEFluidStack.fromFluidStack(extract), new PlayerSource(player, this));
            if (notInserted != null && notInserted.getStackSize() > 0L) {
                AELog.error("Fluid item [%s] reported a different possible amount to drain than it actually provided.", held.func_82833_r());
            }
            player.func_184611_a(hand, fh.getContainer());
        }
        catch (GridAccessException e) {
            e.printStackTrace();
        }
    }

    private void fillFluidContainer(EntityPlayer player, EnumHand hand) {
        try {
            ItemStack held = player.func_184586_b(hand);
            if (held.func_190916_E() != 1) {
                return;
            }
            IFluidHandlerItem fh = FluidUtil.getFluidHandler((ItemStack)held);
            if (fh == null) {
                return;
            }
            IAEFluidStack stack = (IAEFluidStack)this.getDisplayed().copy();
            stack.setStackSize(Integer.MAX_VALUE);
            int amountAllowed = fh.fill(stack.getFluidStack(), false);
            stack.setStackSize(amountAllowed);
            IEnergyGrid energy = this.getProxy().getEnergy();
            IMEMonitor<IAEFluidStack> cell = this.getProxy().getStorage().getInventory(AEApi.instance().storage().getStorageChannel(IFluidStorageChannel.class));
            IAEFluidStack canPull = Platform.poweredExtraction(energy, cell, stack, new PlayerSource(player, this), Actionable.SIMULATE);
            if (canPull == null || canPull.getStackSize() < 1L) {
                return;
            }
            int canFill = fh.fill(canPull.getFluidStack(), false);
            if (canFill == 0) {
                return;
            }
            stack.setStackSize(canFill);
            IAEFluidStack pulled = Platform.poweredExtraction(energy, cell, stack, new PlayerSource(player, this));
            if (pulled == null || pulled.getStackSize() < 1L) {
                AELog.error("Unable to pull fluid out of the ME system even though the simulation said yes ", new Object[0]);
                return;
            }
            int used = fh.fill(pulled.getFluidStack(), true);
            if (used != canFill) {
                AELog.error("Fluid item [%s] reported a different possible amount than it actually accepted.", held.func_82833_r());
            }
            player.func_184611_a(hand, fh.getContainer());
        }
        catch (GridAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public IPartModel getStaticModels() {
        return this.selectModel(MODELS_OFF, MODELS_ON, MODELS_HAS_CHANNEL, MODELS_LOCKED_OFF, MODELS_LOCKED_ON, MODELS_LOCKED_HAS_CHANNEL);
    }
}

