/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionBi;
import buildcraft.lib.expression.node.value.NodeConstantDouble;
import java.util.Objects;

public class NodeFuncObjectToDouble<A>
extends NodeFuncBase
implements INodeFunc.INodeFuncDouble {
    public final IFuncObjectToDouble<A> function;
    private final StringFunctionBi stringFunction;
    private final Class<A> argTypeA;

    public NodeFuncObjectToDouble(String name, Class<A> argTypeA, IFuncObjectToDouble<A> function) {
        this(argTypeA, function, (String a) -> "[ " + NodeTypes.getName(argTypeA) + " -> double ] " + name + "(" + a + ")");
    }

    public NodeFuncObjectToDouble(Class<A> argTypeA, IFuncObjectToDouble<A> function, StringFunctionBi stringFunction) {
        this.argTypeA = argTypeA;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    public String toString() {
        return this.stringFunction.apply("{A}");
    }

    @Override
    public NodeFuncObjectToDouble<A> setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeDouble getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeObject<A> a = stack.popObject(this.argTypeA);
        return this.create(a);
    }

    public FuncObjectToDouble create(IExpressionNode.INodeObject<A> argA) {
        return new FuncObjectToDouble(argA);
    }

    @FunctionalInterface
    public static interface IFuncObjectToDouble<A> {
        public double apply(A var1);
    }

    public class FuncObjectToDouble
    implements IExpressionNode.INodeDouble,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeObject<A> argA;

        public FuncObjectToDouble(IExpressionNode.INodeObject<A> argA) {
            this.argA = argA;
        }

        @Override
        public double evaluate() {
            return NodeFuncObjectToDouble.this.function.apply(this.argA.evaluate());
        }

        @Override
        public IExpressionNode.INodeDouble inline() {
            if (!NodeFuncObjectToDouble.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, a -> new FuncObjectToDouble(a), a -> new FuncObjectToDouble(a));
            }
            return NodeInliningHelper.tryInline(this, this.argA, a -> new FuncObjectToDouble(a), a -> NodeConstantDouble.of(NodeFuncObjectToDouble.this.function.apply(a.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncObjectToDouble.this.canInline) {
                if (NodeFuncObjectToDouble.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncObjectToDouble.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn((IExpressionNode)this.argA);
        }

        public String toString() {
            return NodeFuncObjectToDouble.this.stringFunction.apply(this.argA.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncObjectToDouble.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncObjectToDouble other = (FuncObjectToDouble)obj;
            return Objects.equals(this.argA, other.argA);
        }
    }
}

