/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.plug;

import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.api.transport.pluggable.PluggableDefinition;
import buildcraft.api.transport.pluggable.PluggableModelKey;
import buildcraft.lib.misc.AdvancementUtil;
import buildcraft.transport.BCTransportItems;
import buildcraft.transport.client.model.key.KeyPlugBlocker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;

public class PluggableBlocker
extends PipePluggable {
    private static final AxisAlignedBB[] BOXES = new AxisAlignedBB[6];
    private static final ResourceLocation ADVANCEMENT_PLACE_PLUG = new ResourceLocation("buildcrafttransport:plugging_the_gap");

    public PluggableBlocker(PluggableDefinition definition, IPipeHolder holder, EnumFacing side) {
        super(definition, holder, side);
    }

    @Override
    public AxisAlignedBB getBoundingBox() {
        return BOXES[this.side.func_176745_a()];
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public ItemStack getPickStack() {
        return new ItemStack((Item)BCTransportItems.plugBlocker);
    }

    @Override
    public void onPlacedBy(EntityPlayer player) {
        super.onPlacedBy(player);
        if (!this.holder.getPipeWorld().field_72995_K && this.holder.getPipe().isConnected(this.side)) {
            AdvancementUtil.unlockAdvancement(player, ADVANCEMENT_PLACE_PLUG);
        }
    }

    @Override
    public PluggableModelKey getModelRenderKey(BlockRenderLayer layer) {
        if (layer == BlockRenderLayer.CUTOUT) {
            return new KeyPlugBlocker(this.side);
        }
        return null;
    }

    static {
        double ll = 0.125;
        double lu = 0.25;
        double ul = 0.75;
        double uu = 0.875;
        double min = 0.25;
        double max = 0.75;
        PluggableBlocker.BOXES[EnumFacing.DOWN.func_176745_a()] = new AxisAlignedBB(min, ll, min, max, lu, max);
        PluggableBlocker.BOXES[EnumFacing.UP.func_176745_a()] = new AxisAlignedBB(min, ul, min, max, uu, max);
        PluggableBlocker.BOXES[EnumFacing.NORTH.func_176745_a()] = new AxisAlignedBB(min, min, ll, max, max, lu);
        PluggableBlocker.BOXES[EnumFacing.SOUTH.func_176745_a()] = new AxisAlignedBB(min, min, ul, max, max, uu);
        PluggableBlocker.BOXES[EnumFacing.WEST.func_176745_a()] = new AxisAlignedBB(ll, min, min, lu, max, max);
        PluggableBlocker.BOXES[EnumFacing.EAST.func_176745_a()] = new AxisAlignedBB(ul, min, min, uu, max, max);
    }
}

