/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials;

import com.google.common.collect.ListMultimap;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import thut.essentials.commands.CommandManager;
import thut.essentials.defuzz.SpawnDefuzzer;
import thut.essentials.economy.EconomyManager;
import thut.essentials.itemcontrol.ItemControl;
import thut.essentials.land.LandEventsHandler;
import thut.essentials.land.LandManager;
import thut.essentials.util.ChatHandler;
import thut.essentials.util.ConfigManager;
import thut.essentials.util.HomeManager;
import thut.essentials.util.LogFormatter;
import thut.essentials.util.PlayerDataHandler;
import thut.essentials.world.WorldManager;

@Mod(modid="thutessentials", name="Thut Essentials", version="2.2.23", updateJSON="", acceptableRemoteVersions="*", acceptedMinecraftVersions="[1.12.2]")
public class ThutEssentials {
    public static final String MODID = "thutessentials";
    public static final String VERSION = "2.2.23";
    public static final String UPDATEURL = "";
    @Mod.Instance(value="thutessentials")
    public static ThutEssentials instance;
    public static Logger logger;
    public ConfigManager config;
    private CommandManager manager;
    public SpawnDefuzzer defuz = new SpawnDefuzzer();
    public ItemControl items = new ItemControl();
    public final LandEventsHandler teams = new LandEventsHandler();
    public boolean loaded = false;

    public ThutEssentials() {
        this.initLogger();
    }

    private void initLogger() {
        FileHandler logHandler = null;
        logger.setLevel(Level.ALL);
        try {
            File logs = new File("." + File.separator + "logs");
            logs.mkdirs();
            File logfile = new File(logs, "thutessentials.log");
            if (logfile.exists()) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
                Date date = new Date();
                logs = new File(logs, MODID);
                logs.mkdirs();
                try {
                    File newFile = new File(logs, dateFormat.format(date) + ".log");
                    Files.move((File)logfile, (File)newFile);
                }
                catch (IOException newFile) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (logfile.createNewFile() && logfile.canWrite() && logHandler == null) {
                logHandler = new FileHandler(logfile.getPath());
                logHandler.setFormatter(new LogFormatter());
                logger.addHandler(logHandler);
            }
        }
        catch (IOException | SecurityException e) {
            e.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        this.config = new ConfigManager(e.getSuggestedConfigurationFile());
        this.manager = new CommandManager();
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ForgeChunkManager.PlayerOrderedLoadingCallback(){

            public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
                for (ForgeChunkManager.Ticket ticket : tickets) {
                    if (!ticket.getModId().equals(ThutEssentials.MODID)) continue;
                    if (!ticket.isPlayerTicket() || !ConfigManager.INSTANCE.chunkLoading) {
                        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                        continue;
                    }
                    int[] pos = ticket.getModData().func_74759_k("pos");
                    if (pos.length != 2) {
                        logger.log(Level.FINER, "invalid ticket for " + pos);
                        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                        continue;
                    }
                    ChunkPos location = new ChunkPos(pos[0], pos[1]);
                    logger.log(Level.FINER, "Forcing Chunk at " + location);
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)location);
                }
            }

            public ListMultimap<String, ForgeChunkManager.Ticket> playerTicketsLoaded(ListMultimap<String, ForgeChunkManager.Ticket> tickets, World world) {
                return tickets;
            }
        });
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        if (this.config.chatTweaks) {
            MinecraftForge.EVENT_BUS.register((Object)new ChatHandler());
        }
        this.loaded = true;
        this.teams.registerPerms();
        HomeManager.registerPerms();
        this.manager.registerCommands(event);
        if (this.config.landEnabled) {
            LandManager.getInstance();
        }
        if (this.config.economyEnabled) {
            EconomyManager.getInstance();
        }
        try {
            WorldManager.onServerStart(event);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent evt) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        CommandHandler ch = (CommandHandler)server.func_71187_D();
        for (String s : ConfigManager.INSTANCE.alternateCommands) {
            String[] args = s.split(":");
            ICommand command = (ICommand)ch.func_71555_a().get(args[0]);
            if (command == null) {
                System.err.println("No Command found for " + args[0]);
                continue;
            }
            for (int i = 1; i < args.length; ++i) {
                ch.func_71555_a().put(args[i], command);
            }
        }
        for (String s : ConfigManager.INSTANCE.serverInitCommands) {
            ch.func_71556_a((ICommandSender)server, s);
        }
    }

    @Mod.EventHandler
    public void serverUnload(FMLServerStoppingEvent evt) {
        PlayerDataHandler.saveAll();
        PlayerDataHandler.clear();
        LandManager.clearInstance();
        EconomyManager.clearInstance();
        this.manager.clear();
    }

    static {
        logger = Logger.getLogger(MODID);
    }
}

