/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.areacontrol;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.PlayerContext;
import thut.essentials.util.Transporter;

public class Requirement {
    List<String> neededPerms = Lists.newArrayList();
    IRejection rejection;

    public boolean fills(EntityPlayer player) {
        IPermissionHandler manager = PermissionAPI.getPermissionHandler();
        for (String node : this.neededPerms) {
            if (manager.hasPermission(player.func_146103_bH(), node, (IContext)new PlayerContext(player))) continue;
            return false;
        }
        return true;
    }

    public static class PushReject
    implements IRejection {
        Transporter.Vector3 dir;

        public PushReject() {
        }

        public PushReject(Transporter.Vector3 dir) {
            this.dir = dir;
        }

        @Override
        public void reject(EntityPlayer player) {
            if (this.dir != null) {
                player.func_70024_g((double)this.dir.x, (double)this.dir.y, (double)this.dir.z);
            }
        }
    }

    public static class TeleportReject
    implements IRejection {
        BlockPos pos;
        int dimension;

        public TeleportReject() {
        }

        public TeleportReject(BlockPos pos, int dimension) {
            this.pos = pos;
            this.dimension = dimension;
        }

        @Override
        public void reject(EntityPlayer player) {
            if (this.pos != null) {
                Transporter.teleportEntity((Entity)player, new Transporter.Vector3(this.pos), this.dimension);
            }
        }
    }

    public static interface IRejection {
        public void reject(EntityPlayer var1);
    }
}

