/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntityCommandBlock;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.util.BaseCommand;
import thut.essentials.util.ConfigManager;

public class CommandManager {
    public static Map<String, List<String>> commands = Maps.newHashMap();
    List<Class<? extends BaseCommand>> commandClassList = Lists.newArrayList();
    List<Class<? extends CommandBase>> otherClassCommands = Lists.newArrayList();
    List<BaseCommand> commandList = Lists.newArrayList();

    public static ITextComponent makeFormattedComponent(String text, TextFormatting colour, boolean bold) {
        return new TextComponentString(text).func_150255_a(new Style().func_150227_a(Boolean.valueOf(bold)).func_150238_a(colour));
    }

    public static ITextComponent makeFormattedComponent(String text, TextFormatting colour) {
        return new TextComponentString(text).func_150255_a(new Style().func_150238_a(colour));
    }

    public static ITextComponent makeFormattedCommandLink(String text, String command, TextFormatting colour, boolean bold) {
        return new TextComponentString(text).func_150255_a(new Style().func_150227_a(Boolean.valueOf(bold)).func_150238_a(colour).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command)));
    }

    public static boolean isOp(ICommandSender sender, String bypasslimit) {
        if (sender instanceof EntityPlayer) {
            return PermissionAPI.hasPermission((EntityPlayer)((EntityPlayer)sender), (String)bypasslimit);
        }
        if (sender instanceof TileEntityCommandBlock) {
            return true;
        }
        return sender.func_70005_c_().equalsIgnoreCase("@") || sender.func_70005_c_().equals("Server");
    }

    public CommandManager() {
        HashSet blacklist = Sets.newHashSet((Object[])ConfigManager.INSTANCE.disabledCommands);
        for (String s : ConfigManager.INSTANCE.commands) {
            String[] args = s.split(":");
            ArrayList aliases = Lists.newArrayList();
            for (String s1 : args) {
                aliases.add(s1);
            }
            LinkedHashSet names = Sets.newLinkedHashSet((Iterable)aliases);
            aliases = Lists.newArrayList((Iterable)names);
            commands.put(args[0], aliases);
        }
        try {
            List<Class<?>> foundClasses = ClassFinder.find(CommandManager.class.getPackage().getName());
            ArrayList classNames = Lists.newArrayList();
            for (Class<?> candidateClass : foundClasses) {
                if (!CommandBase.class.isAssignableFrom(candidateClass) || candidateClass.getEnclosingClass() != null) continue;
                classNames.add(candidateClass.getName());
                if (blacklist.contains(candidateClass.getName())) {
                    if (!ConfigManager.INSTANCE.comandDisableSpam) continue;
                    System.out.println("Skipping Blacklisted " + candidateClass);
                    continue;
                }
                if (!ConfigManager.INSTANCE.landEnabled && candidateClass.getName().startsWith("thut.essentials.commands.land")) {
                    if (!ConfigManager.INSTANCE.comandDisableSpam) continue;
                    System.out.println("Skipping Disabled " + candidateClass);
                    continue;
                }
                try {
                    if (BaseCommand.class.isAssignableFrom(candidateClass)) {
                        this.commandClassList.add(candidateClass);
                        continue;
                    }
                    this.otherClassCommands.add(candidateClass);
                }
                catch (Exception e) {
                    if (!ConfigManager.INSTANCE.comandDisableSpam) continue;
                    System.out.println("Error with " + candidateClass);
                }
            }
            Collections.sort(classNames);
            ConfigManager.INSTANCE.updateField(ConfigManager.class.getDeclaredField("allThutEssentialsCommands"), classNames.toArray(new String[0]));
            ConfigManager.INSTANCE.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void registerCommands(FMLServerStartingEvent event) {
        BaseCommand command;
        ConfigManager.INSTANCE.save();
        System.out.println(this.commandClassList);
        System.out.println(this.otherClassCommands);
        for (Class<? extends BaseCommand> clazz : this.commandClassList) {
            try {
                command = clazz.newInstance();
                if (command != null && command.func_71517_b() != null) {
                    this.commandList.add(command);
                    event.registerServerCommand((ICommand)command);
                    continue;
                }
                if (!ConfigManager.INSTANCE.comandDisableSpam) continue;
                System.err.println((Object)((Object)command) + " is not completed.");
            }
            catch (Exception e) {
                if (!ConfigManager.INSTANCE.comandDisableSpam) continue;
                System.out.println("Error with " + clazz);
            }
        }
        for (Class<? extends BaseCommand> clazz : this.otherClassCommands) {
            try {
                command = clazz.newInstance();
                if (command != null && command.func_71517_b() != null) {
                    event.registerServerCommand((ICommand)command);
                    continue;
                }
                if (!ConfigManager.INSTANCE.comandDisableSpam) continue;
                System.err.println((Object)((Object)command) + " is not completed.");
            }
            catch (Exception e) {
                if (!ConfigManager.INSTANCE.comandDisableSpam) continue;
                System.out.println("Error with " + clazz);
            }
        }
        ConfigManager.INSTANCE.commands = new String[this.commandList.size()];
        Collections.sort(this.commandList);
        for (int i = 0; i < this.commandList.size(); ++i) {
            BaseCommand baseCommand = this.commandList.get(i);
            List<String> alii = commands.get(baseCommand.func_71517_b());
            String var = baseCommand.key;
            for (int j = 0; j < alii.size(); ++j) {
                var = var + ":" + alii.get(j);
            }
            ConfigManager.INSTANCE.commands[i] = var;
        }
        try {
            ConfigManager.INSTANCE.updateField(ConfigManager.class.getDeclaredField("commands"), ConfigManager.INSTANCE.commands);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Class<? extends CommandBase> clazz : this.otherClassCommands) {
            if (!ConfigManager.INSTANCE.comandDisableSpam) continue;
            System.err.println(clazz + " is a commandbase instead of basecomand.");
        }
    }

    public void clear() {
        for (BaseCommand c : this.commandList) {
            c.destroy();
        }
    }

    static {
        commands.put("colour", Lists.newArrayList((Object[])new String[]{"colour", "color", "col"}));
        commands.put("tpa", Lists.newArrayList((Object[])new String[]{"tpa"}));
        commands.put("tptoggle", Lists.newArrayList((Object[])new String[]{"tptoggle"}));
        commands.put("fly", Lists.newArrayList((Object[])new String[]{"fly"}));
        commands.put("spawn", Lists.newArrayList((Object[])new String[]{"spawn"}));
        commands.put("back", Lists.newArrayList((Object[])new String[]{"back"}));
        commands.put("staff", Lists.newArrayList((Object[])new String[]{"staff", "sc"}));
        commands.put("heal", Lists.newArrayList((Object[])new String[]{"heal"}));
        commands.put("repair", Lists.newArrayList((Object[])new String[]{"repair"}));
        commands.put("setwarp", Lists.newArrayList((Object[])new String[]{"setwarp"}));
        commands.put("delwarp", Lists.newArrayList((Object[])new String[]{"delwarp"}));
        commands.put("warp", Lists.newArrayList((Object[])new String[]{"warp"}));
        commands.put("sethome", Lists.newArrayList((Object[])new String[]{"sethome"}));
        commands.put("delhome", Lists.newArrayList((Object[])new String[]{"delhome"}));
        commands.put("home", Lists.newArrayList((Object[])new String[]{"home"}));
        commands.put("rules", Lists.newArrayList((Object[])new String[]{"rules"}));
        commands.put("addrule", Lists.newArrayList((Object[])new String[]{"addrule"}));
        commands.put("delrule", Lists.newArrayList((Object[])new String[]{"delrule"}));
    }

    public static class ClassFinder {
        private static final char DOT = '.';
        private static final char SLASH = '/';
        private static final String CLASS_SUFFIX = ".class";
        private static final String BAD_PACKAGE_ERROR = "Unable to get resources from path '%s'. Are you sure the package '%s' exists?";

        public static List<Class<?>> find(String scannedPackage) throws UnsupportedEncodingException {
            ArrayList classes;
            block8: {
                File scannedDir;
                block7: {
                    String scannedPath = scannedPackage.replace('.', '/');
                    URL scannedUrl = Thread.currentThread().getContextClassLoader().getResource(scannedPath);
                    if (scannedUrl == null) {
                        throw new IllegalArgumentException(String.format(BAD_PACKAGE_ERROR, scannedPath, scannedPackage));
                    }
                    scannedDir = new File(URLDecoder.decode(scannedUrl.getFile(), Charset.defaultCharset().name()));
                    classes = new ArrayList();
                    if (!scannedDir.exists()) break block7;
                    for (File file : scannedDir.listFiles()) {
                        classes.addAll(ClassFinder.findInFolder(file, scannedPackage));
                    }
                    break block8;
                }
                if (!scannedDir.toString().contains("file:") || !scannedDir.toString().contains(".jar")) break block8;
                String name = scannedDir.toString();
                String pack = name.split("!")[1].replace(File.separatorChar, '/').substring(1) + '/';
                name = name.replace("file:", "");
                name = name.replaceAll("(.jar)(.*)", ".jar");
                scannedDir = new File(name);
                try {
                    ZipFile zip = new ZipFile(scannedDir);
                    Enumeration<? extends ZipEntry> entries = zip.entries();
                    int n = 0;
                    while (entries.hasMoreElements() && n < 10) {
                        ZipEntry entry = entries.nextElement();
                        String s = entry.getName();
                        if (!s.contains(pack) || !s.endsWith(CLASS_SUFFIX)) continue;
                        try {
                            classes.add(Class.forName(s.replace(CLASS_SUFFIX, "").replace('/', '.')));
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                    zip.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return classes;
        }

        private static List<Class<?>> findInFolder(File file, String scannedPackage) {
            ArrayList classes;
            block4: {
                String resource;
                block3: {
                    classes = new ArrayList();
                    resource = scannedPackage + '.' + file.getName();
                    if (!file.isDirectory()) break block3;
                    for (File child : file.listFiles()) {
                        classes.addAll(ClassFinder.findInFolder(child, resource));
                    }
                    break block4;
                }
                if (!resource.endsWith(CLASS_SUFFIX)) break block4;
                int endIndex = resource.length() - CLASS_SUFFIX.length();
                String className = resource.substring(0, endIndex);
                try {
                    classes.add(Class.forName(className));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return classes;
        }
    }
}

