/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.economy;

import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.economy.EconomyManager;
import thut.essentials.land.LandManager;
import thut.essentials.util.BaseCommand;
import thut.essentials.util.ConfigManager;
import thut.essentials.util.Coordinate;
import thut.essentials.util.PlayerDataHandler;

public class SellLand
extends BaseCommand {
    private static final String PERMSELLOTHERLAND = "thutessentials.economy.sell_land.other";

    public SellLand() {
        super("sell_team_land", 0, new String[0]);
        PermissionAPI.registerNode((String)PERMSELLOTHERLAND, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allowed to sell any land, regardless of owner");
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return super.func_71518_a(sender) + " <player> <cost> <optional|4-coordinates x y z w> or " + super.func_71518_a(sender) + " !clear to clear your current sale offer.";
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (!ConfigManager.INSTANCE.landEnabled) {
            throw new CommandException("Land is not enabled on this server.", new Object[0]);
        }
        EntityPlayerMP player = SellLand.getPlayerBySender(sender);
        if (args.length == 1) {
            if (args[0].equals("!clear")) {
                if (PlayerDataHandler.getCustomDataTag((EntityPlayer)player).func_74764_b("land_sale")) {
                    PlayerDataHandler.getCustomDataTag((EntityPlayer)player).func_82580_o("land_sale");
                    PlayerDataHandler.saveCustomData((EntityPlayer)player);
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Cleared land sale offer!"));
                }
                return;
            }
            if (args[0].equals("!confim")) {
                LandManager.LandTeam buyTeam = LandManager.getTeam((Entity)player);
                if (buyTeam == LandManager.getDefaultTeam()) {
                    throw new CommandException("You cannot buy land for the default team", new Object[0]);
                }
                if (buyTeam.land.land.size() >= ConfigManager.INSTANCE.maxLandViaSalesPerTeam) {
                    throw new CommandException("Your team may not buy any more land.", new Object[0]);
                }
                NBTTagCompound tag = PlayerDataHandler.getCustomDataTag((EntityPlayer)player).func_74775_l("land_sale");
                if (tag.func_82582_d()) {
                    throw new CommandException("You do not have any sale offers.", new Object[0]);
                }
                int cost = tag.func_74762_e("c");
                int balance = EconomyManager.getBalance((EntityPlayer)player);
                if (balance < cost) {
                    throw new CommandException("Insufficient Funds, cost is " + cost, new Object[0]);
                }
                Coordinate coord = new Coordinate(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"), tag.func_74762_e("w"));
                UUID seller = UUID.fromString(tag.func_74779_i("id"));
                EconomyManager.addBalance(seller, cost);
                EconomyManager.addBalance((EntityPlayer)player, -cost);
                EntityPlayerMP sellPlayer = server.func_184103_al().func_177451_a(seller);
                if (sellPlayer != null) {
                    sellPlayer.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Land Sale Complete, you received " + cost));
                }
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Land Sale Complete, you spent " + cost));
                LandManager.getInstance().addTeamLand(buyTeam.teamName, coord, true);
                PlayerDataHandler.getCustomDataTag((EntityPlayer)player).func_82580_o("land_sale");
                PlayerDataHandler.saveCustomData((EntityPlayer)player);
                return;
            }
        }
        if (args.length < 1) {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP target = SellLand.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        Coordinate loc = null;
        LandManager.LandTeam sellTeam = LandManager.getTeam((Entity)player);
        LandManager.LandTeam buyTeam = LandManager.getTeam((Entity)target);
        if (buyTeam == LandManager.getDefaultTeam()) {
            throw new CommandException("You cannot sell land to default team", new Object[0]);
        }
        if (PlayerDataHandler.getCustomDataTag((EntityPlayer)target).func_74764_b("land_sale")) {
            throw new CommandException(target.func_70005_c_() + " already has an outstanding sell offer, they must complete or clear that first.", new Object[0]);
        }
        int cost = SellLand.func_175755_a((String)args[1]);
        if (args.length == 6 && PermissionAPI.hasPermission((EntityPlayer)player, (String)PERMSELLOTHERLAND)) {
            BlockPos pos = SellLand.func_175757_a((ICommandSender)sender, (String[])args, (int)2, (boolean)true);
            loc = Coordinate.getChunkCoordFromWorldCoord(pos, SellLand.func_175755_a((String)args[5]));
        } else if (args.length == 2) {
            if (sellTeam == buyTeam) {
                throw new CommandException("You cannot sell land to your own team", new Object[0]);
            }
            if (sellTeam == LandManager.getDefaultTeam()) {
                throw new CommandException("You cannot sell land for default team", new Object[0]);
            }
            if (!sellTeam.isAdmin((Entity)player)) {
                throw new CommandException("Only team admins may sell land", new Object[0]);
            }
            loc = Coordinate.getChunkCoordFromWorldCoord(player.func_180425_c(), player.field_71093_bK);
            if (!LandManager.getInstance().isTeamLand(loc, sellTeam.teamName)) {
                throw new CommandException("You cannot sell land your team does not own.", new Object[0]);
            }
        }
        if (loc == null) {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("c", cost);
        tag.func_74768_a("x", loc.x);
        tag.func_74768_a("y", loc.y);
        tag.func_74768_a("z", loc.z);
        tag.func_74768_a("w", loc.dim);
        tag.func_74778_a("id", player.func_189512_bd());
        PlayerDataHandler.getCustomDataTag((EntityPlayer)target).func_74782_a("land_sale", (NBTBase)tag);
        PlayerDataHandler.saveCustomData((EntityPlayer)target);
        ITextComponent message = new TextComponentString("==============================================\n").func_150257_a(player.func_145748_c_()).func_150258_a(TextFormatting.AQUA + " Wishes to sell you some land!\n\n");
        message.func_150258_a(TextFormatting.AQUA + "It is sub chunk " + TextFormatting.GOLD + loc.x + " " + loc.y + " " + loc.z + "\n" + TextFormatting.AQUA + "Located in dimension " + TextFormatting.GOLD + loc.dim + "\n\n");
        message.func_150258_a(TextFormatting.AQUA + "The offered price is " + TextFormatting.GOLD + cost + "\n\n");
        TextComponentString accept = new TextComponentString(TextFormatting.GREEN + "Accept");
        accept.func_150255_a(new Style());
        accept.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + this.func_71517_b() + " !confim"));
        TextComponentString deny = new TextComponentString(TextFormatting.RED + "Deny");
        deny.func_150255_a(new Style());
        deny.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + this.func_71517_b() + " !clear"));
        message.func_150257_a((ITextComponent)accept).func_150258_a(" / ").func_150257_a((ITextComponent)deny).func_150258_a("\n==============================================");
        target.func_145747_a(message);
        message = new TextComponentString("==============================================\n").func_150258_a(TextFormatting.AQUA + "Sell offer sent to ").func_150257_a(player.func_145748_c_());
        message.func_150258_a("\n\n" + TextFormatting.AQUA + "It is sub chunk " + TextFormatting.GOLD + loc.x + " " + loc.y + " " + loc.z + "\n" + TextFormatting.AQUA + "Located in dimension " + TextFormatting.GOLD + loc.dim).func_150258_a("\n==============================================");
        sender.func_145747_a(message);
    }
}

