/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.kits;

import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.PlayerContext;
import thut.essentials.economy.EconomyManager;
import thut.essentials.util.BaseCommand;
import thut.essentials.util.ConfigManager;
import thut.essentials.util.KitManager;
import thut.essentials.util.PlayerDataHandler;

public class Kit
extends BaseCommand {
    public Kit() {
        super("kit", 0, new String[0]);
        KitManager.init();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        List<ItemStack> stacks;
        EntityPlayerMP player = Kit.getPlayerBySender(sender);
        int delay = ConfigManager.INSTANCE.kitReuseDelay;
        String kitTag = "kitTime";
        String perm = "thutessentials.kit.default";
        if (args.length == 1) {
            KitManager.KitSet kit = KitManager.kits.get(args[0]);
            if (kit == null) {
                throw new CommandException("No kit by that name found.", new Object[0]);
            }
            perm = "thutessentials.kit." + args[0];
            kitTag = "kitTime_" + args[0];
            delay = kit.cooldown;
            stacks = kit.stacks;
        } else {
            stacks = KitManager.kit;
        }
        IPermissionHandler manager = PermissionAPI.getPermissionHandler();
        PlayerContext context = new PlayerContext((EntityPlayer)player);
        if (!manager.hasPermission(player.func_146103_bH(), perm, (IContext)context)) {
            throw new CommandException("You are not allowed to get that kit!", new Object[0]);
        }
        long kitTime = PlayerDataHandler.getCustomDataTag((EntityPlayer)player).func_74763_f(kitTag);
        if (delay <= 0 && kitTime != 0L || server.func_130014_f_().func_82737_E() < kitTime) {
            throw new CommandException("You cannot get another kit yet.", new Object[0]);
        }
        for (ItemStack stack : stacks) {
            EconomyManager.giveItem((EntityPlayer)player, stack.func_77946_l());
            PlayerDataHandler.getCustomDataTag((EntityPlayer)player).func_74772_a(kitTag, server.func_130014_f_().func_82737_E() + (long)delay);
        }
    }
}

