/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.claims;

import java.util.logging.Level;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.ThutEssentials;
import thut.essentials.events.LoadLandEvent;
import thut.essentials.land.LandEventsHandler;
import thut.essentials.land.LandManager;
import thut.essentials.util.BaseCommand;
import thut.essentials.util.ConfigManager;
import thut.essentials.util.Coordinate;

public class Load
extends BaseCommand {
    private static final String BYPASSLIMIT = "thutessentials.land.cload.nolimit";
    private static final String LOADCHUNKS = "thutessentials.land.cload.load";

    public Load() {
        super("cload", 0, new String[0]);
        PermissionAPI.registerNode((String)BYPASSLIMIT, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Permission to bypass the chunk loaded land per player limit for a team.");
        PermissionAPI.registerNode((String)LOADCHUNKS, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Permission to load chunks.");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int maxLoaded;
        EntityPlayerMP player = Load.getPlayerBySender(sender);
        LandManager.LandTeam team = LandManager.getTeam((Entity)player);
        if (team == LandManager.getDefaultTeam()) {
            throw new CommandException("You are not in a team that can claim land.", new Object[0]);
        }
        if (!team.hasRankPerm(player.func_110124_au(), "cload")) {
            throw new CommandException("You are not allowed to do that.", new Object[0]);
        }
        int x = MathHelper.func_76141_d((float)((float)sender.func_180425_c().func_177958_n() / 16.0f));
        int y = MathHelper.func_76141_d((float)((float)sender.func_180425_c().func_177956_o() / 16.0f));
        int z = MathHelper.func_76141_d((float)((float)sender.func_180425_c().func_177952_p() / 16.0f));
        int dim = sender.func_130014_f_().field_73011_w.getDimension();
        Coordinate chunk = new Coordinate(x, y, z, dim);
        LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(chunk);
        if (owner != team) {
            throw new CommandException("You may only load land owned by your team.", new Object[0]);
        }
        int n = maxLoaded = team.maxLoaded < 0 ? ConfigManager.INSTANCE.loadedChunksPerTeam : team.maxLoaded;
        if (maxLoaded >= team.land.loaded) {
            throw new CommandException("You have too much land loaded, please unload some first.", new Object[0]);
        }
        if (LandEventsHandler.ChunkLoadHandler.chunks.containsKey(chunk)) {
            throw new CommandException("Already loaded.", new Object[0]);
        }
        LoadLandEvent event = new LoadLandEvent(new BlockPos(x, y, z), dim, (EntityPlayer)player, team.teamName);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            LandManager.getInstance().loadLand(player.func_130014_f_(), chunk, team);
            sender.func_145747_a((ITextComponent)new TextComponentString("Loaded subchunk for Team" + team.teamName));
            ThutEssentials.logger.log(Level.FINER, "load: " + team.teamName + " " + chunk);
        }
    }
}

