/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.claims;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.land.LandManager;
import thut.essentials.util.BaseCommand;
import thut.essentials.util.Coordinate;

public class UnClaim
extends BaseCommand {
    public UnClaim() {
        super("unclaim", 0, new String[0]);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = UnClaim.getPlayerBySender(sender);
        LandManager.LandTeam team = LandManager.getTeam((Entity)player);
        if (!team.hasRankPerm(player.func_110124_au(), "unclaim")) {
            throw new CommandException("You are not allowed to do that.", new Object[0]);
        }
        boolean up = false;
        int num = 1;
        int n = 0;
        boolean unclaimAny = PermissionAPI.hasPermission((EntityPlayer)player, (String)"thutessentials.land.unclaim.owned.other");
        if (args.length > 1) {
            try {
                if (args[0].equalsIgnoreCase("up") || args[0].equalsIgnoreCase("down")) {
                    num = Integer.parseInt(args[1]);
                    up = args[0].equalsIgnoreCase("up");
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (args[0].equalsIgnoreCase("chunk")) {
                for (int i = 0; i < 16; ++i) {
                    int dir = up ? -1 : 1;
                    int x = MathHelper.func_76141_d((float)((float)sender.func_180425_c().func_177958_n() / 16.0f));
                    int y = dir * i;
                    int z = MathHelper.func_76141_d((float)((float)sender.func_180425_c().func_177952_p() / 16.0f));
                    int dim = sender.func_130014_f_().field_73011_w.getDimension();
                    Coordinate c = new Coordinate(x, y, z, dim);
                    LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
                    if (!unclaimAny && owner != null && !team.equals(owner)) {
                        throw new CommandException("You may not unclaim that land.", new Object[0]);
                    }
                    if (y < 0 || y > 15) continue;
                    ++n;
                    LandManager.getInstance().removeTeamLand(team.teamName, c);
                }
                if (n > 0) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Unclaimed This land for Team" + team.teamName));
                }
                return;
            }
        }
        if (args.length > 1 && args[0].equalsIgnoreCase("all")) {
            ArrayList toRemove = Lists.newArrayList(team.land.land);
            for (Coordinate c : toRemove) {
                LandManager.getInstance().removeTeamLand(team.teamName, c);
            }
            sender.func_145747_a((ITextComponent)new TextComponentString("Unclaimed all land for Team" + team.teamName));
            return;
        }
        for (int i = 0; i < num; ++i) {
            int dir = up ? -1 : 1;
            int x = MathHelper.func_76141_d((float)((float)sender.func_180425_c().func_177958_n() / 16.0f));
            int y = MathHelper.func_76141_d((float)((float)sender.func_180425_c().func_177956_o() / 16.0f)) + dir * i;
            int z = MathHelper.func_76141_d((float)((float)sender.func_180425_c().func_177952_p() / 16.0f));
            int dim = sender.func_130014_f_().field_73011_w.getDimension();
            Coordinate c = new Coordinate(x, y, z, dim);
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (!unclaimAny && owner != null && !team.equals(owner)) {
                throw new CommandException("You may not unclaim that land.", new Object[0]);
            }
            if (y < 0 || y > 15) continue;
            ++n;
            LandManager.getInstance().removeTeamLand(team.teamName, c);
        }
        if (n > 0) {
            sender.func_145747_a((ITextComponent)new TextComponentString("Unclaimed This land for Team" + team.teamName));
        }
    }
}

