/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.management;

import com.mojang.authlib.GameProfile;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import thut.essentials.land.LandManager;
import thut.essentials.land.LandSaveHandler;
import thut.essentials.util.BaseCommand;

public class EditRanks
extends BaseCommand {
    public EditRanks() {
        super("teamranks", 0, new String[0]);
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 2;
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return super.func_71518_a(sender) + " <arg> <player> <value>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String type;
        EntityPlayerMP player = EditRanks.getPlayerBySender(sender);
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        if (!landTeam.isAdmin((Entity)player)) {
            throw new CommandException("Only Team Admins may manage ranks", new Object[0]);
        }
        if (args.length == 0) {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
        switch (type = args[0]) {
            case "addRank": {
                String rankName = args[1];
                LandManager.PlayerRank rank = landTeam.rankMap.get(rankName);
                if (rank != null) {
                    throw new CommandException("Rank " + rankName + " already exists.", new Object[0]);
                }
                landTeam.rankMap.put(rankName, new LandManager.PlayerRank());
                player.func_145747_a((ITextComponent)new TextComponentString("Added Rank " + rankName));
                LandSaveHandler.saveTeam(landTeam.teamName);
                break;
            }
            case "setRank": {
                String rankName = args[1];
                EntityPlayerMP target = EditRanks.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[2]);
                LandManager.PlayerRank rank = landTeam.rankMap.get(rankName);
                if (rank == null) {
                    throw new CommandException("Rank " + rankName + " does not exist.", new Object[0]);
                }
                rank.members.add(target.func_110124_au());
                landTeam._ranksMembers.put(target.func_110124_au(), rank);
                target.refreshDisplayName();
                player.func_145747_a((ITextComponent)new TextComponentString("Added " + target.func_70005_c_() + " to Rank " + rankName));
                LandSaveHandler.saveTeam(landTeam.teamName);
                break;
            }
            case "setPerm": {
                String rankName = args[1];
                LandManager.PlayerRank rank = landTeam.rankMap.get(rankName);
                if (rank == null) {
                    throw new CommandException("Rank " + rankName + " does not exist.", new Object[0]);
                }
                String perm = args[2];
                boolean added = rank.perms.add(perm);
                if (added) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Allowed " + perm));
                    break;
                }
                player.func_145747_a((ITextComponent)new TextComponentString("Already has " + perm));
                break;
            }
            case "delPerm": {
                String rankName = args[1];
                LandManager.PlayerRank rank = landTeam.rankMap.get(rankName);
                if (rank == null) {
                    throw new CommandException("Rank " + rankName + " does not exist.", new Object[0]);
                }
                String perm = args[2];
                boolean added = rank.perms.remove(perm);
                if (added) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Removed " + perm));
                    break;
                }
                player.func_145747_a((ITextComponent)new TextComponentString("Did not have " + perm));
                break;
            }
            case "setPrefix": {
                boolean added;
                String perm;
                String rankName = args[1];
                LandManager.PlayerRank rank = landTeam.rankMap.get(rankName);
                if (rank == null) {
                    throw new CommandException("Rank " + rankName + " does not exist.", new Object[0]);
                }
                rank.prefix = perm = args[2];
                if (perm.trim().isEmpty()) {
                    rank.prefix = null;
                }
                boolean bl = added = rank.prefix != null;
                if (added) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Set Prefix to " + rank.prefix));
                    break;
                }
                player.func_145747_a((ITextComponent)new TextComponentString("Removed Rank Prefix"));
                break;
            }
            case "listRanks": {
                Set<String> ranks = landTeam.rankMap.keySet();
                player.func_145747_a((ITextComponent)new TextComponentString("Ranks in your team:"));
                for (String s : ranks) {
                    player.func_145747_a((ITextComponent)new TextComponentString("  " + s));
                }
                break;
            }
            case "listMembers": {
                String rankName = args[1];
                LandManager.PlayerRank rank = landTeam.rankMap.get(rankName);
                if (rank == null) {
                    throw new CommandException("Rank " + rankName + " does not exist.", new Object[0]);
                }
                Set<UUID> c = rank.members;
                player.func_145747_a((ITextComponent)new TextComponentString("Members of " + rankName));
                for (UUID o : c) {
                    GameProfile profile = EditRanks.getProfile(server, o);
                    sender.func_145747_a((ITextComponent)new TextComponentString("  " + profile.getName()));
                }
                break;
            }
        }
    }
}

