/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.management;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import thut.essentials.land.LandManager;
import thut.essentials.land.LandSaveHandler;
import thut.essentials.util.BaseCommand;

public class EditRelations
extends BaseCommand {
    public static List<String> perms = Lists.newArrayList();
    public static Map<String, String> perm_info = Maps.newHashMap();

    public EditRelations() {
        super("teamrelations", 0, new String[0]);
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 2;
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return super.func_71518_a(sender) + " <relations|perms|set|unset> if set/unset, then <team> <perm>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = EditRelations.getPlayerBySender(sender);
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        if (!landTeam.isAdmin((Entity)player)) {
            throw new CommandException("Only Team Admins may manage relations", new Object[0]);
        }
        if (args.length == 0) {
            throw new CommandException(this.func_71518_a(sender), new Object[0]);
        }
        String type = args[0];
        ArrayList keys = Lists.newArrayList(landTeam.relations.keySet());
        switch (type) {
            case "relations": {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Relations of " + landTeam.teamName));
                for (String s : keys) {
                    LandManager.Relation relation = landTeam.relations.get(s);
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "    " + s));
                    for (String s1 : relation.perms) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "        " + s1));
                    }
                }
                break;
            }
            case "perms": {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Allowed Relation Permissions:"));
                for (String s : perms) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "    " + s + " - " + perm_info.get(s)));
                }
                break;
            }
            case "set": {
                if (args.length != 3) {
                    throw new CommandException(this.func_71518_a(sender), new Object[0]);
                }
                String other = args[1];
                String perm = args[2];
                if (!perms.contains(perm)) {
                    throw new CommandException("Use " + super.func_71518_a(sender) + " perms for a list of valid options", new Object[0]);
                }
                LandManager.LandTeam team = LandManager.getInstance().getTeam(other, false);
                if (team == null) {
                    throw new CommandException(other + " is not an existing team.", new Object[0]);
                }
                LandManager.Relation relation = landTeam.relations.get(other);
                if (relation == null) {
                    relation = new LandManager.Relation();
                    landTeam.relations.put(other, relation);
                }
                if (relation.perms.add(perm)) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Set perm " + perm + " for " + other));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + other + " already had " + perm));
                }
                LandSaveHandler.saveTeam(other);
                break;
            }
            case "unset": {
                if (args.length != 3) {
                    throw new CommandException(this.func_71518_a(sender), new Object[0]);
                }
                String other = args[1];
                String perm = args[2];
                if (!perms.contains(perm)) {
                    throw new CommandException("Use " + super.func_71518_a(sender) + " perms for a list of valid options", new Object[0]);
                }
                LandManager.LandTeam team = LandManager.getInstance().getTeam(other, false);
                if (team == null) {
                    throw new CommandException(other + " is not an existing team.", new Object[0]);
                }
                LandManager.Relation relation = landTeam.relations.get(other);
                if (relation == null) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "No Relations with " + other));
                    return;
                }
                if (relation.perms.remove(perm)) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + "Removed perm " + perm + " for " + other));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.AQUA + other + " does not have perm " + perm));
                }
                if (relation.perms.isEmpty()) {
                    landTeam.relations.remove(other);
                }
                LandSaveHandler.saveTeam(other);
            }
        }
    }

    static {
        perms.add("break");
        perms.add("place");
        perms.add("public");
        perms.add("ally");
        perm_info.put("break", "Allowd to break blocks.");
        perm_info.put("place", "Allowd to place blocks.");
        perm_info.put("public", "Everything counts as if Public Toggle was used.");
        perm_info.put("ally", "Counts as \"Ally\" by anything that uses that.");
        Collections.sort(perms);
    }
}

