/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.management;

import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.land.LandManager;
import thut.essentials.land.LandSaveHandler;
import thut.essentials.util.BaseCommand;
import thut.essentials.util.ConfigManager;
import thut.essentials.util.Coordinate;
import thut.essentials.util.RuleManager;

public class EditTeam
extends BaseCommand {
    private static final String PERMRESERVELAND = "thutessentials.land.toggle.reserve";
    private static final String PERMTOGGLEMOBS = "thutessentials.land.toggle.mobspawn";
    private static final String PERMTOGGLEEXPLODE = "thutessentials.land.toggle.explode";
    private static final String PERMTOGGLEFF = "thutessentials.land.toggle.friendlyfire";
    private static final String PERMTOGGLEPLAYERDAMAGE = "thutessentials.land.toggle.playerdamage";
    private static final String PERMTOGGLEFAKEPLAYERS = "thutessentials.land.toggle.fakeplayers";

    public EditTeam() {
        super("editteam", 0, new String[0]);
        PermissionAPI.registerNode((String)PERMTOGGLEEXPLODE, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allowed to toggle explosions on/off in their team land");
        PermissionAPI.registerNode((String)PERMTOGGLEMOBS, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allowed to toggle mob spawns on/off in their team land");
        PermissionAPI.registerNode((String)PERMRESERVELAND, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allowed to toggle reserved status on/off for their team");
        PermissionAPI.registerNode((String)PERMTOGGLEFF, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allowed to toggle friendly fire on/off for their team");
        PermissionAPI.registerNode((String)PERMTOGGLEPLAYERDAMAGE, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allowed to toggle player damage on/off in their team land");
        PermissionAPI.registerNode((String)PERMTOGGLEFAKEPLAYERS, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Allowed to toggle whether fakeplayers are ignored for land stuff.");
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = EditTeam.getPlayerBySender(sender);
        LandManager.LandTeam landTeam = LandManager.getTeam((Entity)player);
        String arg = args[0];
        String message = "";
        if (args.length > 1) {
            message = args[1];
        }
        for (int i = 2; i < args.length; ++i) {
            message = message + " " + args[i];
        }
        message = RuleManager.format(message);
        if (arg.equalsIgnoreCase("public")) {
            if (!landTeam.isAdmin((Entity)player)) {
                throw new CommandException("You are not allowed to do that.", new Object[0]);
            }
            landTeam.allPublic = EditTeam.func_180527_d((String)message);
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Set all public to " + message));
            LandSaveHandler.saveTeam(landTeam.teamName);
            return;
        }
        if (arg.equalsIgnoreCase("anyPlace")) {
            if (!landTeam.isAdmin((Entity)player)) {
                throw new CommandException("You are not allowed to do that.", new Object[0]);
            }
            landTeam.anyPlace = EditTeam.func_180527_d((String)message);
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Set anyPlace to " + message));
            LandSaveHandler.saveTeam(landTeam.teamName);
            return;
        }
        if (arg.equalsIgnoreCase("frames")) {
            if (!landTeam.isAdmin((Entity)player)) {
                throw new CommandException("You are not allowed to do that.", new Object[0]);
            }
            landTeam.protectFrames = EditTeam.func_180527_d((String)message);
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Set protected frames to " + message));
            LandSaveHandler.saveTeam(landTeam.teamName);
            return;
        }
        if (arg.equalsIgnoreCase("fakePlayers") && PermissionAPI.hasPermission((EntityPlayer)player, (String)PERMTOGGLEFAKEPLAYERS)) {
            if (!landTeam.isAdmin((Entity)player)) {
                throw new CommandException("You are not allowed to do that.", new Object[0]);
            }
            landTeam.anyPlace = EditTeam.func_180527_d((String)message);
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Set anyPlace to " + message));
            LandSaveHandler.saveTeam(landTeam.teamName);
            return;
        }
        if (arg.equalsIgnoreCase("anyBreak")) {
            if (!landTeam.isAdmin((Entity)player)) {
                throw new CommandException("You are not allowed to do that.", new Object[0]);
            }
            landTeam.anyBreak = EditTeam.func_180527_d((String)message);
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Set anyBreak to " + message));
            LandSaveHandler.saveTeam(landTeam.teamName);
            return;
        }
        if (arg.equalsIgnoreCase("exit")) {
            if (!landTeam.hasRankPerm(player.func_110124_au(), "editMessages")) {
                throw new CommandException("You are not allowed to do that.", new Object[0]);
            }
            landTeam.exitMessage = message;
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Set Exit Message to " + message));
            LandSaveHandler.saveTeam(landTeam.teamName);
            return;
        }
        if (arg.equalsIgnoreCase("enter")) {
            if (!landTeam.hasRankPerm(player.func_110124_au(), "editMessages")) {
                throw new CommandException("You are not allowed to do that.", new Object[0]);
            }
            landTeam.enterMessage = message;
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Set Enter Message to " + message));
            LandSaveHandler.saveTeam(landTeam.teamName);
            return;
        }
        if (arg.equalsIgnoreCase("deny")) {
            if (!landTeam.hasRankPerm(player.func_110124_au(), "editMessages")) {
                throw new CommandException("You are not allowed to do that.", new Object[0]);
            }
            landTeam.denyMessage = message;
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Set Deny Message to " + message));
            LandSaveHandler.saveTeam(landTeam.teamName);
            return;
        }
        if (arg.equalsIgnoreCase("prefix")) {
            if (!landTeam.hasRankPerm(player.func_110124_au(), "prefix")) {
                throw new CommandException("You are not allowed to do that.", new Object[0]);
            }
            if (message.length() > ConfigManager.INSTANCE.prefixLength) {
                message = message.substring(0, ConfigManager.INSTANCE.prefixLength);
            }
            landTeam.prefix = message;
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Set Prefix to " + TextFormatting.RESET + message));
            EditTeam.refreshTeam(landTeam, server);
            LandSaveHandler.saveTeam(landTeam.teamName);
            return;
        }
        if (arg.equalsIgnoreCase("home")) {
            if (!landTeam.hasRankPerm(player.func_110124_au(), "sethome")) {
                throw new CommandException("You are not allowed to do that.", new Object[0]);
            }
            landTeam.home = new Coordinate(player.func_180425_c(), player.field_71093_bK);
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Set Team Home to " + landTeam.home));
            LandSaveHandler.saveTeam(landTeam.teamName);
            return;
        }
        if (arg.equalsIgnoreCase("reserve") && PermissionAPI.hasPermission((EntityPlayer)player, (String)PERMRESERVELAND)) {
            landTeam.reserved = Boolean.parseBoolean(message);
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "reserved set to " + landTeam.reserved));
            LandSaveHandler.saveTeam(landTeam.teamName);
            return;
        }
        if (arg.equalsIgnoreCase("noPlayerDamage") && PermissionAPI.hasPermission((EntityPlayer)player, (String)PERMTOGGLEPLAYERDAMAGE)) {
            landTeam.noPlayerDamage = Boolean.parseBoolean(message);
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "noPlayerDamage set to " + landTeam.noPlayerDamage));
            LandSaveHandler.saveTeam(landTeam.teamName);
            return;
        }
        if (arg.equalsIgnoreCase("friendlyFire") && PermissionAPI.hasPermission((EntityPlayer)player, (String)PERMTOGGLEFF)) {
            landTeam.friendlyFire = Boolean.parseBoolean(message);
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "friendlyFire set to " + landTeam.friendlyFire));
            LandSaveHandler.saveTeam(landTeam.teamName);
            return;
        }
        if (arg.equalsIgnoreCase("noMobSpawn") && PermissionAPI.hasPermission((EntityPlayer)player, (String)PERMTOGGLEMOBS)) {
            landTeam.noMobSpawn = Boolean.parseBoolean(message);
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "noMobSpawn set to " + landTeam.noMobSpawn));
            LandSaveHandler.saveTeam(landTeam.teamName);
            return;
        }
        if (arg.equalsIgnoreCase("noExplosions") && PermissionAPI.hasPermission((EntityPlayer)player, (String)PERMTOGGLEEXPLODE)) {
            landTeam.noExplosions = Boolean.parseBoolean(message);
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "noExplosions set to " + landTeam.noExplosions));
            LandSaveHandler.saveTeam(landTeam.teamName);
            return;
        }
    }

    public static void refreshTeam(LandManager.LandTeam team, MinecraftServer server) {
        for (UUID id : team.member) {
            try {
                EntityPlayerMP player = server.func_184103_al().func_177451_a(id);
                if (player == null) continue;
                player.refreshDisplayName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

