/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.land.util;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import thut.essentials.land.LandManager;
import thut.essentials.util.BaseCommand;

public class ListMembers
extends BaseCommand {
    public ListMembers() {
        super("listmembers", 0, new String[0]);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        LandManager.LandTeam team = LandManager.getTeam((Entity)ListMembers.getPlayerBySender(sender));
        if (args.length == 1) {
            team = LandManager.getInstance().getTeam(args[0], false);
        }
        if (team == null) {
            throw new CommandException("No team found by name " + args[0], new Object[0]);
        }
        String teamName = team.teamName;
        sender.func_145747_a((ITextComponent)new TextComponentString("Members of Team " + teamName + ":"));
        sender.func_145747_a(ListMembers.getMembers(server, team, true));
    }

    public static ITextComponent getMembers(MinecraftServer server, LandManager.LandTeam team, boolean tabbed) {
        TextComponentString mess = new TextComponentString("");
        Set<UUID> c = team.member;
        ArrayList ids = Lists.newArrayList(c);
        for (int i = 0; i < ids.size(); ++i) {
            UUID o = (UUID)ids.get(i);
            if (o == null) continue;
            GameProfile profile = ListMembers.getProfile(server, o);
            if (tabbed) {
                mess.func_150258_a("    ");
            }
            if (profile.getName() != null) {
                mess.func_150258_a(profile.getName());
            } else {
                mess.func_150258_a("<unknown> " + o);
            }
            if (i >= ids.size() - 1) continue;
            mess.func_150258_a("\n");
        }
        System.out.println(mess);
        return mess;
    }
}

