/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.misc;

import java.util.function.Predicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thut.essentials.ThutEssentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.commands.misc.Spawn;
import thut.essentials.events.MoveEvent;
import thut.essentials.util.BaseCommand;
import thut.essentials.util.ConfigManager;
import thut.essentials.util.Coordinate;
import thut.essentials.util.PlayerDataHandler;

public class Back
extends BaseCommand {
    public Back() {
        super("back", 0, new String[0]);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void move(MoveEvent event) {
        PlayerDataHandler.getCustomDataTag(event.getEntityLiving().func_189512_bd()).func_74783_a("prevPos", event.getPos());
    }

    @SubscribeEvent
    public void death(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            BlockPos pos = event.getEntityLiving().func_180425_c();
            int[] loc = new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), event.getEntityLiving().field_71093_bK};
            PlayerDataHandler.getCustomDataTag(event.getEntityLiving().func_189512_bd()).func_74783_a("prevPos", loc);
            PlayerDataHandler.saveCustomData(event.getEntityLiving().func_189512_bd());
        }
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Coordinate spot;
        long time;
        EntityPlayerMP player = Back.getPlayerBySender(sender);
        final NBTTagCompound tag = PlayerDataHandler.getCustomDataTag((EntityPlayer)player);
        final NBTTagCompound tptag = tag.func_74775_l("tp");
        long last = tptag.func_74763_f("backDelay");
        if (last > (time = player.func_184102_h().func_71218_a(0).func_82737_E())) {
            player.func_145747_a(CommandManager.makeFormattedComponent("Too Soon between Warp attempt", TextFormatting.RED, false));
            return;
        }
        if (PlayerDataHandler.getCustomDataTag((EntityPlayer)player).func_74764_b("prevPos")) {
            int[] pos = PlayerDataHandler.getCustomDataTag((EntityPlayer)player).func_74759_k("prevPos");
            spot = this.getBackSpot(pos);
            if (spot == null) {
                throw new CommandException("Error with going back, no space found", new Object[0]);
            }
        } else {
            throw new CommandException("No valid /back destination", new Object[0]);
        }
        Predicate<Entity> callback = new Predicate<Entity>(){

            @Override
            public boolean test(Entity t) {
                if (!(t instanceof EntityPlayer)) {
                    return false;
                }
                PlayerDataHandler.getCustomDataTag(t.func_189512_bd()).func_82580_o("prevPos");
                tptag.func_74772_a("backDelay", time + (long)ConfigManager.INSTANCE.backReUseDelay);
                tag.func_74782_a("tp", (NBTBase)tptag);
                PlayerDataHandler.saveCustomData((EntityPlayer)t);
                return true;
            }
        };
        ITextComponent teleMess = CommandManager.makeFormattedComponent("Warping to Previous Location", TextFormatting.GREEN);
        Spawn.PlayerMover.setMove((EntityPlayer)player, ThutEssentials.instance.config.backActivateDelay, spot.dim, new BlockPos(spot.x, spot.y, spot.z), teleMess, Spawn.INTERUPTED, callback, false);
    }

    private Coordinate getBackSpot(int[] pos) {
        Coordinate spot = new Coordinate(pos[0], pos[1], pos[2], pos[3]);
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(pos[3]);
        if (world == null) {
            return null;
        }
        BlockPos check = new BlockPos(spot.x, spot.y, spot.z);
        if (this.valid(check, (World)world)) {
            return spot;
        }
        int r = ConfigManager.INSTANCE.backRangeCheck;
        for (int j = 0; j < r; ++j) {
            for (int i = 0; i < r; ++i) {
                for (int k = 0; k < r; ++k) {
                    spot = new Coordinate(pos[0] + i, pos[1] + j, pos[2] + k, pos[3]);
                    check = new BlockPos(spot.x, spot.y, spot.z);
                    if (this.valid(check, (World)world)) {
                        return spot;
                    }
                    spot = new Coordinate(pos[0] - i, pos[1] + j, pos[2] - k, pos[3]);
                    check = new BlockPos(spot.x, spot.y, spot.z);
                    if (!this.valid(check, (World)world)) continue;
                    return spot;
                }
            }
        }
        return null;
    }

    private boolean valid(BlockPos pos, World world) {
        IBlockState state1 = world.func_180495_p(pos);
        IBlockState state2 = world.func_180495_p(pos.func_177984_a());
        boolean valid1 = state1 == null || !state1.func_185904_a().func_76220_a();
        boolean valid2 = state2 == null || !state2.func_185904_a().func_76220_a();
        return valid1 && valid2;
    }
}

