/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.misc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.PlayerContext;
import thut.essentials.ThutEssentials;
import thut.essentials.util.BaseCommand;
import thut.essentials.util.ConfigManager;
import thut.essentials.util.Configure;

public class Config
extends BaseCommand {
    public static final String EDITPERM = "thutessentials.command.config.edit";
    ArrayList<String> fields = Lists.newArrayList();
    HashMap<String, Field> fieldMap = Maps.newHashMap();

    public Config() {
        super("teconfig", 0, new String[0]);
        PermissionAPI.registerNode((String)EDITPERM, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player edit configs via the command.");
        this.populateFields();
    }

    @Override
    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        boolean op = Config.isOp(sender);
        if (args.length == 0) {
            throw new CommandException("arguments error, press tab for options", new Object[0]);
        }
        boolean check = args.length <= 1;
        Field field = this.fieldMap.get(args[0]);
        if (field == null) {
            throw new CommandException("arguments error, press tab for options", new Object[0]);
        }
        try {
            String text = "";
            Object o = field.get((Object)ThutEssentials.instance.config);
            text = o instanceof String[] ? text + Arrays.toString((Object[])o) : (o instanceof int[] ? text + Arrays.toString((int[])o) : text + o);
            TextComponentTranslation mess = new TextComponentTranslation("thutcore.command.settings.check", new Object[]{args[0], text});
            if (check) {
                sender.func_145747_a((ITextComponent)mess);
                return;
            }
            if (!op) {
                throw new CommandException("No permission to do that", new Object[0]);
            }
            try {
                String val = args[1];
                if (args.length > 2) {
                    for (int i = 2; i < args.length; ++i) {
                        val = val + " " + args[i];
                    }
                }
                ThutEssentials.instance.config.updateField(field, val);
            }
            catch (Exception e) {
                throw new CommandException("invalid options", new Object[0]);
            }
            text = "";
            o = field.get((Object)ThutEssentials.instance.config);
            text = o instanceof String[] ? text + Arrays.toString((Object[])o) : (o instanceof int[] ? text + Arrays.toString((int[])o) : text + o);
            mess = new TextComponentTranslation("thutcore.command.settings.set", new Object[]{args[0], text});
            sender.func_145747_a((ITextComponent)mess);
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CommandException("unknown error", new Object[0]);
        }
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b() + "<option name> <optional:newvalue>";
    }

    @Override
    public int func_82362_a() {
        return 4;
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        ArrayList<String> ret = new ArrayList<String>();
        if (args.length == 1) {
            String text = args[0];
            for (String name : this.fields) {
                if (!name.contains(text)) continue;
                ret.add(name);
            }
            Collections.sort(ret, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
        }
        return ret;
    }

    private void populateFields() {
        Class<ConfigManager> me = ConfigManager.class;
        for (Field f : me.getDeclaredFields()) {
            Configure c = f.getAnnotation(Configure.class);
            if (c == null) continue;
            f.setAccessible(true);
            this.fields.add(f.getName());
            this.fieldMap.put(f.getName(), f);
        }
    }

    public static boolean isOp(ICommandSender sender) {
        if (sender instanceof EntityPlayerMP) {
            IPermissionHandler manager = PermissionAPI.getPermissionHandler();
            return manager.hasPermission(((EntityPlayerMP)sender).func_146103_bH(), EDITPERM, (IContext)new PlayerContext((EntityPlayer)sender));
        }
        return sender.func_70005_c_().equalsIgnoreCase("@") || sender.func_70005_c_().equals("Server");
    }
}

