/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.misc;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.vecmath.Tuple3f;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thut.essentials.ThutEssentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.events.MoveEvent;
import thut.essentials.util.BaseCommand;
import thut.essentials.util.ConfigManager;
import thut.essentials.util.PlayerDataHandler;
import thut.essentials.util.Transporter;

public class Spawn
extends BaseCommand {
    public static final ITextComponent INTERUPTED = new TextComponentString(TextFormatting.RED + "" + TextFormatting.ITALIC + "You must remain still to do that");

    public Spawn() {
        super("spawn", 0, new String[0]);
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        long time;
        EntityPlayerMP player = Spawn.getPlayerBySender(sender);
        NBTTagCompound tag = PlayerDataHandler.getCustomDataTag((EntityPlayer)player);
        NBTTagCompound tptag = tag.func_74775_l("tp");
        long last = tptag.func_74763_f("spawnDelay");
        if (last > (time = player.func_184102_h().func_71218_a(0).func_82737_E())) {
            player.func_145747_a(CommandManager.makeFormattedComponent("Too Soon between Warp attempt", TextFormatting.RED, false));
            return;
        }
        if (args.length == 0) {
            BlockPos spawn = server.func_71218_a(ThutEssentials.instance.config.spawnDimension).func_175694_M();
            ITextComponent teleMess = CommandManager.makeFormattedComponent("Warped to Spawn", TextFormatting.GREEN);
            PlayerMover.setMove((EntityPlayer)player, ThutEssentials.instance.config.spawnActivateDelay, ThutEssentials.instance.config.spawnDimension, spawn, teleMess, INTERUPTED);
            tptag.func_74772_a("spawnDelay", time + (long)ConfigManager.INSTANCE.spawnReUseDelay);
            tag.func_74782_a("tp", (NBTBase)tptag);
            PlayerDataHandler.saveCustomData((EntityPlayer)player);
        } else if (args[0].equalsIgnoreCase("me")) {
            BlockPos spawn = player.func_180470_cg();
            if (spawn != null) {
                ITextComponent teleMess = CommandManager.makeFormattedComponent("Warped to Bed location", TextFormatting.GREEN);
                PlayerMover.setMove((EntityPlayer)player, ThutEssentials.instance.config.spawnActivateDelay, player.field_71093_bK, spawn, teleMess, INTERUPTED);
                tptag.func_74772_a("spawnDelay", time + (long)ConfigManager.INSTANCE.spawnReUseDelay);
                tag.func_74782_a("tp", (NBTBase)tptag);
            } else {
                throw new CommandException("no bed found", new Object[0]);
            }
        }
    }

    public static class PlayerMover {
        private static Transporter.Vector3 offset = new Transporter.Vector3(0.5, 0.5, 0.5);
        static Map<UUID, Mover> toMove = Maps.newHashMap();

        public static void setMove(EntityPlayer player, int moveTime, int dimension, BlockPos moveTo, ITextComponent message, ITextComponent failMess) {
            PlayerMover.setMove(player, moveTime, dimension, moveTo, message, failMess, true);
        }

        public static void setMove(EntityPlayer player, int moveTime, int dimension, BlockPos moveTo, ITextComponent message, ITextComponent failMess, boolean event) {
            PlayerMover.setMove(player, moveTime, dimension, moveTo, message, failMess, null, event);
        }

        public static void setMove(final EntityPlayer player, final int moveTime, final int dimension, final BlockPos moveTo, final ITextComponent message, final ITextComponent failMess, final Predicate<Entity> callback, final boolean event) {
            if (player.func_184218_aH() || player.func_184207_aI()) {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Please Dismount then try again."));
                return;
            }
            player.func_184102_h().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    if (!toMove.containsKey(player.func_110124_au())) {
                        long time = moveTime;
                        if (time > 0L) {
                            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Initiating Teleport, please remain still."));
                            time += player.func_130014_f_().func_82737_E();
                        }
                        toMove.put(player.func_110124_au(), new Mover(player, time, dimension, moveTo, message, failMess, callback, event));
                    }
                }
            });
        }

        @SubscribeEvent
        public void playerTick(LivingEvent.LivingUpdateEvent tick) {
            if (toMove.containsKey(tick.getEntity().func_110124_au())) {
                Mover mover = toMove.get(tick.getEntity().func_110124_au());
                Transporter.Vector3 loc = new Transporter.Vector3(mover.player.field_70165_t, mover.player.field_70163_u, mover.player.field_70161_v);
                Transporter.Vector3 diff = new Transporter.Vector3(mover.start.x, mover.start.y, mover.start.z);
                diff.sub((Tuple3f)loc);
                if ((double)diff.lengthSquared() > 0.0 && mover.moveTime > 0L) {
                    if (mover.failMess != null) {
                        tick.getEntity().func_145747_a(mover.failMess);
                    }
                    toMove.remove(tick.getEntity().func_110124_au());
                    return;
                }
                if (tick.getEntity().func_130014_f_().func_82737_E() > mover.moveTime) {
                    mover.move();
                    toMove.remove(tick.getEntity().func_110124_au());
                }
            }
        }

        static {
            MinecraftForge.EVENT_BUS.register((Object)new PlayerMover());
        }

        private static class Mover {
            final long moveTime;
            final EntityPlayer player;
            final int dimension;
            final BlockPos moveTo;
            final Transporter.Vector3 start;
            final ITextComponent message;
            final ITextComponent failMess;
            final boolean event;
            final Predicate<Entity> callback;

            public Mover(EntityPlayer player, long moveTime, int dimension, BlockPos moveTo, ITextComponent message, ITextComponent failMess, Predicate<Entity> callback, boolean event) {
                this.player = player;
                this.dimension = dimension;
                this.moveTime = moveTime;
                this.moveTo = moveTo;
                this.message = message;
                this.failMess = failMess;
                this.event = event;
                this.callback = callback;
                this.start = new Transporter.Vector3(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            }

            private void move() {
                if (this.event) {
                    MinecraftForge.EVENT_BUS.post((Event)new MoveEvent(this.player));
                }
                Transporter.Vector3 dest = new Transporter.Vector3(this.moveTo);
                dest.add((Tuple3f)offset);
                if (ConfigManager.INSTANCE.log_teleports) {
                    ThutEssentials.logger.log(Level.FINER, "TP: " + this.player.func_110124_au() + " " + this.player.func_70005_c_() + " from: " + (Object)((Object)this.start) + " to " + this.moveTo);
                }
                Entity player1 = Transporter.teleportEntity((Entity)this.player, dest, this.dimension);
                if (this.callback != null) {
                    this.callback.test(player1);
                }
                if (this.message != null) {
                    player1.func_145747_a(this.message);
                }
            }
        }
    }
}

