/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.commands.rtp;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.ThutEssentials;
import thut.essentials.commands.misc.Spawn;
import thut.essentials.util.BaseCommand;
import thut.essentials.util.ConfigManager;
import thut.essentials.util.PlayerDataHandler;

public class RTP
extends BaseCommand {
    private static final String PERMRTPOTHER = "thutessentials.rtp.other";

    public RTP() {
        super("rtp", 0, new String[0]);
        PermissionAPI.registerNode((String)PERMRTPOTHER, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Is allowed to cast RTP on someone else?");
    }

    public boolean func_82358_a(String[] args, int index) {
        return index == 0;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        BlockPos position;
        EntityPlayerMP player;
        if (args.length == 1) {
            if (sender instanceof EntityPlayer && !PermissionAPI.hasPermission((EntityPlayer)((EntityPlayer)sender), (String)PERMRTPOTHER)) {
                throw new CommandException("You do not have permission to RTP someone else.", new Object[0]);
            }
            player = RTP.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[0]);
        } else {
            player = RTP.getPlayerBySender(sender);
        }
        int delay = ConfigManager.INSTANCE.rtpReuseDelay;
        String timeTag = "rtp_time";
        long rtpTime = PlayerDataHandler.getCustomDataTag((EntityPlayer)player).func_74763_f(timeTag);
        if (delay <= 0 && rtpTime != 0L || server.func_130014_f_().func_82737_E() < rtpTime) {
            throw new CommandException("You cannot RTP again yet.", new Object[0]);
        }
        PlayerDataHandler.getCustomDataTag((EntityPlayer)player).func_74772_a(timeTag, server.func_130014_f_().func_82737_E() + (long)delay);
        int n = 100;
        while ((position = this.checkSpot((EntityPlayer)player)) == null && n-- > 0) {
        }
        if (position != null) {
            Spawn.PlayerMover.setMove((EntityPlayer)player, ThutEssentials.instance.config.rtpActivateDelay, player.field_71093_bK, position, null, Spawn.INTERUPTED);
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString("No spot found."));
        }
    }

    private boolean isValid(IBlockState ground, IBlockState lower, IBlockState upper) {
        return ground.func_185898_k() && this.validMaterial(lower.func_185904_a()) && this.validMaterial(upper.func_185904_a());
    }

    private boolean validMaterial(Material mat) {
        return !mat.func_76220_a() && !mat.func_76224_d();
    }

    private BlockPos calculatePos() {
        Random rand = new Random();
        int x = (int)(Math.signum(rand.nextGaussian()) * (double)rand.nextInt(ConfigManager.INSTANCE.rtpdistance));
        int z = (int)(Math.signum(rand.nextGaussian()) * (double)rand.nextInt(ConfigManager.INSTANCE.rtpdistance));
        int y = 252;
        return new BlockPos(x, y, z);
    }

    private BlockPos checkSpot(EntityPlayer player) {
        IBlockState upper;
        IBlockState lower;
        BlockPos position = this.calculatePos();
        IBlockState ground = player.func_130014_f_().func_180495_p(position);
        if (this.isValid(ground, lower = player.func_130014_f_().func_180495_p(position.func_177984_a()), upper = player.func_130014_f_().func_180495_p(position.func_177981_b(2)))) {
            return position;
        }
        if (ground.func_185904_a().func_76224_d()) {
            return null;
        }
        while (!this.isValid(ground, lower, upper) && position.func_177956_o() > 0) {
            position = position.func_177977_b();
            ground = player.func_130014_f_().func_180495_p(position);
            lower = player.func_130014_f_().func_180495_p(position.func_177984_a());
            upper = player.func_130014_f_().func_180495_p(position.func_177981_b(2));
            if (!ground.func_185904_a().func_76224_d()) continue;
            return null;
        }
        return position.func_177981_b(2);
    }
}

