/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.economy;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.economy.EconomySaveHandler;
import thut.essentials.land.LandSaveHandler;
import thut.essentials.util.CompatWrapper;
import thut.essentials.util.ConfigManager;
import thut.essentials.util.Coordinate;

public class EconomyManager {
    public static final int VERSION = 1;
    public static final String PERMMAKESHOP = "thutessentials.economy.make_shop";
    public static final String PERMMAKEINFSHOP = "thutessentials.economy.make_infinite_shop";
    public static final String PERMKILLSHOP = "thutessentials.economy.kill_shop";
    public static final String PERMKILLSHOPOTHER = "thutessentials.economy.kill_shop_other";
    public static final UUID DEFAULT_ID = new UUID(0L, 0L);
    public static EconomyManager instance;
    private static boolean init;
    public int version = 1;
    public int initial = 1000;
    public Map<UUID, Account> bank = Maps.newHashMap();
    public Map<Coordinate, Account> _shopMap = Maps.newHashMap();
    public Map<Account, UUID> _revBank = Maps.newHashMap();

    public static void clearInstance() {
        if (instance != null) {
            LandSaveHandler.saveGlobalData();
            MinecraftForge.EVENT_BUS.unregister((Object)instance);
        }
        instance = null;
    }

    public static EconomyManager getInstance() {
        if (instance == null) {
            EconomySaveHandler.loadGlobalData();
            if (!init) {
                init = true;
                PermissionAPI.registerNode((String)PERMMAKESHOP, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Allowed to make a shop that sells from a chest.");
                PermissionAPI.registerNode((String)PERMMAKEINFSHOP, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allowed to make a shop that sells infinite items.");
                PermissionAPI.registerNode((String)PERMKILLSHOP, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Allowed to remove a shop made by this player.");
                PermissionAPI.registerNode((String)PERMKILLSHOPOTHER, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Allowed to remove a shop made by another player.");
            }
        }
        return instance;
    }

    public EconomyManager() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        Account master = new Account();
        master.balance = Integer.MAX_VALUE;
        this.bank.put(DEFAULT_ID, master);
    }

    @SubscribeEvent(receiveCanceled=true)
    public void interactRightClickEntity(PlayerInteractEvent.EntityInteract evt) {
        if (evt.getWorld().field_72995_K) {
            return;
        }
        if (!ConfigManager.INSTANCE.shopsEnabled) {
            return;
        }
        if (evt.getTarget() instanceof EntityItemFrame) {
            Coordinate c = new Coordinate(evt.getPos().func_177977_b(), evt.getEntityPlayer().field_71093_bK);
            Shop shop = EconomyManager.getShop(c);
            TileEntity tile = evt.getWorld().func_175625_s(new BlockPos(c.x, c.y, c.z));
            if (evt.getItemStack() != null && tile instanceof TileEntitySign && shop == null && (evt.getItemStack().func_82833_r().contains("Shop") || evt.getItemStack().func_82833_r().contains("InfShop"))) {
                String permission;
                boolean infinite = evt.getItemStack().func_82833_r().contains("InfShop");
                String string = permission = infinite ? PERMMAKEINFSHOP : PERMMAKESHOP;
                if (!PermissionAPI.hasPermission((EntityPlayer)evt.getEntityPlayer(), (String)permission)) {
                    evt.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You are not allowed to make that shop."));
                    return;
                }
                try {
                    boolean noTag = evt.getItemStack().func_82833_r().contains("noTag");
                    shop = EconomyManager.addShop(evt.getEntityPlayer(), (EntityItemFrame)evt.getTarget(), c, infinite, noTag);
                    evt.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Successfully created the shop. "));
                }
                catch (Exception e) {
                    evt.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Error making shop. " + e));
                }
            }
            if (shop != null) {
                evt.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void projectileImpact(ProjectileImpactEvent evt) {
        Coordinate c;
        Shop shop;
        if (evt.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        if (!ConfigManager.INSTANCE.shopsEnabled) {
            return;
        }
        if (evt.getRayTraceResult() == null) {
            return;
        }
        if (evt.getRayTraceResult().field_72308_g == null) {
            return;
        }
        Entity target = evt.getRayTraceResult().field_72308_g;
        if (target instanceof EntityItemFrame && (shop = EconomyManager.getShop(c = new Coordinate(target.func_180425_c().func_177979_c(2), target.field_71093_bK))) != null) {
            evt.setCanceled(true);
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void interactLeftClickEntity(AttackEntityEvent evt) {
        Coordinate c;
        Shop shop;
        if (evt.getEntityPlayer().func_130014_f_().field_72995_K) {
            return;
        }
        if (!ConfigManager.INSTANCE.shopsEnabled) {
            return;
        }
        if (evt.getTarget() instanceof EntityItemFrame && (shop = EconomyManager.getShop(c = new Coordinate(evt.getTarget().func_180425_c().func_177979_c(2), evt.getTarget().field_71093_bK))) != null) {
            String perm;
            evt.setCanceled(true);
            Account account = this._shopMap.get(c);
            UUID owner = this._revBank.get(account);
            String string = perm = evt.getEntityPlayer().func_110124_au().equals(owner) ? PERMKILLSHOP : PERMKILLSHOPOTHER;
            if (PermissionAPI.hasPermission((EntityPlayer)evt.getEntityPlayer(), (String)perm)) {
                EconomyManager.removeShop(c);
                evt.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Removed the shop."));
            } else {
                evt.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Cannot remove the shop."));
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void interactRightClickBlock(PlayerInteractEvent.RightClickBlock evt) {
        if (evt.getWorld().field_72995_K || !ConfigManager.INSTANCE.shopsEnabled) {
            return;
        }
        Coordinate c = new Coordinate(evt.getPos(), evt.getEntityPlayer().field_71093_bK);
        Shop shop = EconomyManager.getShop(c);
        if (shop != null) {
            shop.transact(evt.getEntityPlayer(), evt.getItemStack(), this._shopMap.get(c));
        }
    }

    public Account getAccount(UUID player) {
        Account account = this.bank.get(player);
        if (account == null) {
            account = new Account();
            this.bank.put(player, account);
            account._id = player;
            account.balance = this.initial;
            EconomySaveHandler.saveGlobalData();
        }
        return account;
    }

    public Account getAccount(EntityPlayer player) {
        return this.getAccount(player.func_110124_au());
    }

    public static Shop addShop(EntityPlayer owner, EntityItemFrame frame, Coordinate location, boolean infinite, boolean noTag) {
        Shop shop = new Shop();
        shop.infinite = infinite;
        shop.frameId = frame.func_110124_au();
        shop.location = location;
        shop.ignoreTag = noTag;
        Account account = EconomyManager.getInstance().getAccount(infinite ? DEFAULT_ID : owner.func_110124_au());
        account.shops.add(shop);
        account._shopMap.put(location, shop);
        EconomyManager.getInstance()._shopMap.put(location, account);
        if (!shop.infinite) {
            TileEntity down = owner.func_130014_f_().func_175625_s(new BlockPos(location.x, location.y - 1, location.z));
            if (down instanceof TileEntitySign) {
                String[] var = ((TileEntitySign)down).field_145915_a[0].func_150260_c().split(",");
                int dx = Integer.parseInt(var[0]);
                int dy = Integer.parseInt(var[1]);
                int dz = Integer.parseInt(var[2]);
                BlockPos pos = new BlockPos(location.x + dx, location.y + dy, location.z + dz);
                BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(owner.func_130014_f_(), pos, owner.func_130014_f_().func_180495_p(pos), owner);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    owner.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You may not link that inventory to the shop!"));
                    return null;
                }
                shop.storage = new Coordinate(location.x + dx, location.y + dy, location.z + dz, location.dim);
            } else {
                shop.storage = new Coordinate(location.x, location.y - 1, location.z, location.dim);
            }
        }
        EconomySaveHandler.saveGlobalData();
        return shop;
    }

    public static void removeShop(Coordinate location) {
        Account account = EconomyManager.getInstance()._shopMap.remove(location);
        if (account != null) {
            account.shops.remove(account._shopMap.remove(location));
            EconomySaveHandler.saveGlobalData();
        }
    }

    public static Shop getShop(Coordinate location) {
        Account account = EconomyManager.getInstance()._shopMap.get(location);
        if (account == null) {
            return null;
        }
        return account._shopMap.get(location);
    }

    public static int getBalance(EntityPlayer player) {
        return EconomyManager.getBalance(player.func_110124_au());
    }

    public static void setBalance(EntityPlayer player, int amount) {
        EconomyManager.setBalance(player.func_110124_au(), amount);
    }

    public static void addBalance(EntityPlayer player, int amount) {
        EconomyManager.addBalance(player.func_110124_au(), amount);
    }

    public static int getBalance(UUID player) {
        return EconomyManager.getInstance().getAccount((UUID)player).balance;
    }

    public static void setBalance(UUID player, int amount) {
        Account account = EconomyManager.getInstance().getAccount(player);
        account.balance = amount;
        EconomySaveHandler.saveGlobalData();
    }

    public static void addBalance(UUID player, int amount) {
        Account account = EconomyManager.getInstance().getAccount(player);
        account.balance += amount;
        EconomySaveHandler.saveGlobalData();
    }

    public static void giveItem(EntityPlayer entityplayer, ItemStack itemstack) {
        boolean flag = entityplayer.field_71071_by.func_70441_a(itemstack);
        if (flag) {
            entityplayer.field_70170_p.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((entityplayer.func_70681_au().nextFloat() - entityplayer.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityplayer.field_71069_bz.func_75142_b();
        } else {
            EntityItem entityitem = entityplayer.func_71019_a(itemstack, false);
            if (entityitem != null) {
                entityitem.func_174868_q();
                entityitem.func_145797_a(entityplayer.func_70005_c_());
            }
        }
    }

    static {
        init = false;
    }

    public static class Shop {
        Coordinate location;
        Coordinate storage;
        UUID frameId;
        boolean infinite = false;
        boolean ignoreTag = false;
        boolean recycle = false;
        boolean sell;
        int cost;
        int number;

        public boolean transact(EntityPlayer player, ItemStack heldStack, Account shopAccount) {
            TileEntity tile;
            ItemStack stack = ItemStack.field_190927_a;
            Entity ent = player.func_184102_h().func_71218_a(player.field_71093_bK).func_175733_a(this.frameId);
            if (ent instanceof EntityItemFrame) {
                stack = ((EntityItemFrame)ent).func_82335_i();
            }
            if (!((tile = player.field_70170_p.func_175625_s(new BlockPos(this.location.x, this.location.y, this.location.z))) instanceof TileEntitySign)) {
                EconomyManager.removeShop(this.location);
                return false;
            }
            TileEntitySign sign = (TileEntitySign)tile;
            this.sell = sign.field_145915_a[0].func_150260_c().contains("Sell") || sign.field_145915_a[0].func_150260_c().contains("Sale");
            this.recycle = sign.field_145915_a[0].func_150260_c().contains("Recycle");
            try {
                this.number = Integer.parseInt(sign.field_145915_a[1].func_150260_c());
                if (this.ignoreTag) {
                    if (this.number != 1) {
                        sign.field_145915_a[1] = new TextComponentString("1");
                    }
                    this.number = 1;
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return false;
            }
            try {
                this.cost = Integer.parseInt(sign.field_145915_a[3].func_150260_c());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return false;
            }
            if (this.recycle && heldStack.func_190926_b()) {
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You need to hold the item you want to recycle"));
                return false;
            }
            if (stack.func_190926_b()) {
                EconomyManager.removeShop(this.location);
                return false;
            }
            if (this.sell) {
                int balance = EconomyManager.getBalance(player);
                if (balance < this.cost) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You have Insufficient Funds"));
                    return false;
                }
                stack = stack.func_77946_l();
                CompatWrapper.setStackSize(stack, this.number);
                if (!this.infinite) {
                    TileEntity inventory;
                    int count = 0;
                    IInventory inv = null;
                    ItemStack test2 = stack.func_77946_l();
                    if (this.storage != null && (inventory = player.field_70170_p.func_175625_s(new BlockPos(this.storage.x, this.storage.y, this.storage.z))) instanceof IInventory) {
                        inv = (IInventory)inventory;
                        if (this.ignoreTag) {
                            test2.func_77982_d(new NBTTagCompound());
                        }
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            ItemStack item = inv.func_70301_a(i);
                            if (item.func_190926_b()) continue;
                            ItemStack test = item.func_77946_l();
                            if (this.ignoreTag) {
                                test.func_77982_d(new NBTTagCompound());
                            }
                            CompatWrapper.setStackSize(test, this.number);
                            if (!ItemStack.func_77989_b((ItemStack)test, (ItemStack)test2)) continue;
                            count += CompatWrapper.getStackSize(item);
                        }
                    }
                    if (count < this.number || inv == null) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Shop Has Insufficient Items"));
                        return false;
                    }
                    int i = 0;
                    Item itemIn = test2.func_77973_b();
                    int metadataIn = test2.func_77952_i();
                    int removeCount = this.number;
                    NBTTagCompound itemNBT = this.ignoreTag ? null : test2.func_77978_p();
                    for (int j = 0; j < inv.func_70302_i_(); ++j) {
                        ItemStack itemstack = inv.func_70301_a(j);
                        if (itemstack.func_190926_b() || itemstack.func_77973_b() != itemIn || metadataIn > -1 && itemstack.func_77960_j() != metadataIn || itemNBT != null && !NBTUtil.func_181123_a((NBTBase)itemNBT, (NBTBase)itemstack.func_77978_p(), (boolean)true)) continue;
                        int k = removeCount <= 0 ? CompatWrapper.getStackSize(itemstack) : Math.min(removeCount - i, CompatWrapper.getStackSize(itemstack));
                        i += k;
                        if (this.number == 1) {
                            stack.func_77982_d(itemstack.func_77978_p());
                        }
                        if (removeCount == 0) continue;
                        CompatWrapper.increment(itemstack, -k);
                        if (!CompatWrapper.isValid(itemstack)) {
                            inv.func_70299_a(j, ItemStack.field_190927_a);
                        }
                        if (removeCount > 0 && i >= removeCount) break;
                    }
                }
                EconomyManager.giveItem(player, stack);
                EconomyManager.addBalance(shopAccount._id, this.cost);
                EconomyManager.addBalance(player, -this.cost);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Remaining Balance: " + TextFormatting.GOLD + EconomyManager.getBalance(player)));
            } else {
                int balance;
                int n = balance = this.infinite ? Integer.MAX_VALUE : shopAccount.balance;
                if (balance < this.cost) {
                    player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Shop has Insufficient Funds"));
                    return false;
                }
                int count = 0;
                if (this.recycle) {
                    count = CompatWrapper.getStackSize(heldStack);
                    if (count < this.number) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You have Insufficient Items"));
                        return false;
                    }
                    stack = heldStack;
                } else {
                    stack = stack.func_77946_l();
                    CompatWrapper.setStackSize(stack, this.number);
                    for (ItemStack item : player.field_71071_by.field_70462_a) {
                        if (item.func_190926_b()) continue;
                        ItemStack test = item.func_77946_l();
                        CompatWrapper.setStackSize(test, this.number);
                        if (!ItemStack.func_77989_b((ItemStack)test, (ItemStack)stack)) continue;
                        count += CompatWrapper.getStackSize(item);
                    }
                    if (count < this.number) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You have Insufficient Items"));
                        return false;
                    }
                }
                if (!this.infinite) {
                    if (this.storage == null) {
                        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "No Storage"));
                        return false;
                    }
                    TileEntity te = player.field_70170_p.func_175625_s(new BlockPos(this.storage.x, this.storage.y, this.storage.z));
                    if (te instanceof IInventory) {
                        IInventory inv = (IInventory)te;
                        count = 0;
                        ItemStack a = stack;
                        count = CompatWrapper.getStackSize(a);
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            if (!CompatWrapper.isValid(inv.func_70301_a(i)) || a.func_77969_a(inv.func_70301_a(i))) {
                                int n2 = 0;
                                if (CompatWrapper.isValid(inv.func_70301_a(i)) && (n2 = CompatWrapper.getStackSize(inv.func_70301_a(i)) + CompatWrapper.getStackSize(a)) < 65) {
                                    CompatWrapper.setStackSize(a, n2);
                                    count = 0;
                                    inv.func_70299_a(i, a.func_77946_l());
                                } else if (!CompatWrapper.isValid(inv.func_70301_a(i))) {
                                    count = 0;
                                    inv.func_70299_a(i, a.func_77946_l());
                                }
                            }
                            if (count == 0) break;
                        }
                    }
                }
                player.field_71071_by.func_174925_a(stack.func_77973_b(), stack.func_77952_i(), this.number, stack.func_77978_p());
                EconomyManager.addBalance(shopAccount._id, -this.cost);
                EconomyManager.addBalance(player, this.cost);
                player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Remaining Balance: " + TextFormatting.GOLD + EconomyManager.getBalance(player)));
            }
            return false;
        }
    }

    public static class Account {
        int balance;
        Set<Shop> shops = Sets.newHashSet();
        UUID _id;
        Map<Coordinate, Shop> _shopMap = Maps.newHashMap();
    }
}

