/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.economy;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.FileUtils;
import thut.essentials.economy.EconomyManager;

public class EconomySaveHandler {
    static ExclusionStrategy exclusion = new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes f) {
            String name = f.getName();
            return name.startsWith("_");
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    };

    public static File getGlobalFolder() {
        String folder = FMLCommonHandler.instance().getMinecraftServerInstance().func_71270_I();
        File file = FMLCommonHandler.instance().getSavesDirectory();
        File saveFolder = new File(file, folder);
        File teamsFolder = new File(saveFolder, "economy");
        if (!teamsFolder.exists()) {
            teamsFolder.mkdirs();
        }
        return teamsFolder;
    }

    public static void saveGlobalData() {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            return;
        }
        Gson gson = new GsonBuilder().addSerializationExclusionStrategy(exclusion).setPrettyPrinting().create();
        EconomyManager.getInstance().version = 1;
        String json = gson.toJson((Object)EconomyManager.getInstance());
        File teamsFile = new File(EconomySaveHandler.getGlobalFolder(), "economy.json");
        try {
            FileUtils.writeStringToFile((File)teamsFile, (String)json, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadGlobalData() {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            return;
        }
        File teamsFile = new File(EconomySaveHandler.getGlobalFolder(), "economy.json");
        if (teamsFile.exists()) {
            try {
                Gson gson = new GsonBuilder().addDeserializationExclusionStrategy(exclusion).setPrettyPrinting().create();
                String json = FileUtils.readFileToString((File)teamsFile, (String)"UTF-8");
                EconomyManager.instance = (EconomyManager)gson.fromJson(json, EconomyManager.class);
                for (Map.Entry<UUID, EconomyManager.Account> entry : EconomyManager.instance.bank.entrySet()) {
                    UUID id;
                    EconomyManager.Account account = entry.getValue();
                    account._id = id = entry.getKey();
                    EconomyManager.instance._revBank.put(account, id);
                    for (EconomyManager.Shop shop : account.shops) {
                        account._shopMap.put(shop.location, shop);
                        EconomyManager.instance._shopMap.put(shop.location, account);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (EconomyManager.instance == null) {
                EconomyManager.instance = new EconomyManager();
            }
            EconomySaveHandler.saveGlobalData();
        }
    }
}

