/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.land;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemFood;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.ThutEssentials;
import thut.essentials.events.DenyItemUseEvent;
import thut.essentials.land.LandManager;
import thut.essentials.land.LandSaveHandler;
import thut.essentials.util.CompatWrapper;
import thut.essentials.util.ConfigManager;
import thut.essentials.util.Coordinate;

public class LandEventsHandler {
    public static Set<String> itemUseWhitelist = Sets.newHashSet();
    public static Set<String> blockUseWhiteList = Sets.newHashSet();
    public static Set<String> blockBreakWhiteList = Sets.newHashSet();
    public static Set<String> blockPlaceWhiteList = Sets.newHashSet();
    public static final String PERMBREAKWILD = "thutessentials.land.break.unowned";
    public static final String PERMBREAKOWN = "thutessentials.land.break.owned.self";
    public static final String PERMBREAKOTHER = "thutessentials.land.break.owned.other";
    public static final String PERMPLACEWILD = "thutessentials.land.place.unowned";
    public static final String PERMPLACEOWN = "thutessentials.land.place.owned.self";
    public static final String PERMPLACEOTHER = "thutessentials.land.place.owned.other";
    public static final String PERMUSEITEMWILD = "thutessentials.land.useitem.unowned";
    public static final String PERMUSEITEMOWN = "thutessentials.land.useitem.owned.self";
    public static final String PERMUSEITEMOTHER = "thutessentials.land.useitem.owned.other";
    public static final String PERMUSEBLOCKWILD = "thutessentials.land.useblock.unowned";
    public static final String PERMUSEBLOCKOWN = "thutessentials.land.useblock.owned.self";
    public static final String PERMUSEBLOCKOTHER = "thutessentials.land.useblock.owned.other";
    public static final String PERMENTERWILD = "thutessentials.land.enter.unowned";
    public static final String PERMENTEROWN = "thutessentials.land.enter.owned.self";
    public static final String PERMENTEROTHER = "thutessentials.land.enter.owned.other";
    public static final String PERMCREATETEAM = "thutessentials.teams.create";
    public static final String PERMJOINTEAMINVITED = "thutessentials.teams.join.invite";
    public static final String PERMJOINTEAMNOINVITE = "thutessentials.teams.join.force";
    public static final String PERMPROTECTMOB = "thutessentials.teams.protect.mob";
    public static final String PERMUNCLAIMOTHER = "thutessentials.land.unclaim.owned.other";
    static Map<UUID, Long> lastLeaveMessage = Maps.newHashMap();
    static Map<UUID, Long> lastEnterMessage = Maps.newHashMap();
    private boolean registered = false;
    protected InteractEventHandler interact_handler = new InteractEventHandler();
    protected EntityEventHandler entity_handler = new EntityEventHandler();
    protected BlockEventHandler block_handler = new BlockEventHandler();
    public Set<UUID> checked = Sets.newHashSet();
    public List<GameProfile> toCheck = Lists.newArrayList();
    private static final byte DENY = 0;
    private static final byte ENTER = 1;
    private static final byte EXIT = 2;

    public static void init() {
        MinecraftForge.EVENT_BUS.unregister((Object)ThutEssentials.instance.teams);
        MinecraftForge.EVENT_BUS.unregister((Object)ThutEssentials.instance.teams.interact_handler);
        MinecraftForge.EVENT_BUS.unregister((Object)ThutEssentials.instance.teams.entity_handler);
        MinecraftForge.EVENT_BUS.unregister((Object)ThutEssentials.instance.teams.block_handler);
        itemUseWhitelist.clear();
        for (String s : ConfigManager.INSTANCE.itemUseWhitelist) {
            itemUseWhitelist.add(s);
        }
        blockUseWhiteList.clear();
        for (String s : ConfigManager.INSTANCE.blockUseWhitelist) {
            blockUseWhiteList.add(s);
        }
        blockBreakWhiteList.clear();
        for (String s : ConfigManager.INSTANCE.blockBreakWhitelist) {
            blockBreakWhiteList.add(s);
        }
        blockPlaceWhiteList.clear();
        for (String s : ConfigManager.INSTANCE.blockPlaceWhitelist) {
            blockPlaceWhiteList.add(s);
        }
        MinecraftForge.EVENT_BUS.register((Object)ThutEssentials.instance.teams);
        MinecraftForge.EVENT_BUS.register((Object)ThutEssentials.instance.teams.interact_handler);
        MinecraftForge.EVENT_BUS.register((Object)ThutEssentials.instance.teams.entity_handler);
        MinecraftForge.EVENT_BUS.register((Object)ThutEssentials.instance.teams.block_handler);
    }

    public static boolean sameTeam(Entity a, Entity b) {
        return LandManager.getTeam(a) == LandManager.getTeam(b);
    }

    public void registerPerms() {
        if (this.registered) {
            return;
        }
        this.registered = true;
        PermissionAPI.registerNode((String)PERMBREAKWILD, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player break blocks in unowned land.");
        PermissionAPI.registerNode((String)PERMBREAKOWN, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player break blocks in their own land.");
        PermissionAPI.registerNode((String)PERMBREAKOTHER, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player break blocks in other player's land.");
        PermissionAPI.registerNode((String)PERMPLACEWILD, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player place blocks in unowned land.");
        PermissionAPI.registerNode((String)PERMPLACEOWN, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player place blocks in their own land.");
        PermissionAPI.registerNode((String)PERMPLACEOTHER, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player place blocks in other player's land.");
        PermissionAPI.registerNode((String)PERMUSEITEMWILD, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use items in unowned land.");
        PermissionAPI.registerNode((String)PERMUSEITEMOWN, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use items in their own land.");
        PermissionAPI.registerNode((String)PERMUSEITEMOTHER, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player use items in other player's land.");
        PermissionAPI.registerNode((String)PERMUSEBLOCKWILD, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use items in unowned land.");
        PermissionAPI.registerNode((String)PERMUSEBLOCKOWN, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player use items in their own land.");
        PermissionAPI.registerNode((String)PERMUSEBLOCKOTHER, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player use items in other player's land.");
        PermissionAPI.registerNode((String)PERMENTERWILD, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player enter unowned land.");
        PermissionAPI.registerNode((String)PERMENTEROWN, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player enter their own land.");
        PermissionAPI.registerNode((String)PERMENTEROTHER, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player enter other player's land.");
        PermissionAPI.registerNode((String)PERMCREATETEAM, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player create a team.");
        PermissionAPI.registerNode((String)PERMJOINTEAMINVITED, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player join a team with an invite.");
        PermissionAPI.registerNode((String)PERMJOINTEAMNOINVITE, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player join a team without an invite.");
        PermissionAPI.registerNode((String)PERMPROTECTMOB, (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player protect mobs in their team's land.");
        PermissionAPI.registerNode((String)PERMUNCLAIMOTHER, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Can the player unclaim any land.");
    }

    public void queueUpdate(GameProfile profile) {
        if (profile.getId() == null) {
            return;
        }
        if (this.checked.contains(profile.getId())) {
            return;
        }
        this.toCheck.add(profile);
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (this.toCheck.isEmpty() || event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server.func_130014_f_().func_82737_E() % 5L != 0L) {
            return;
        }
        GameProfile profile = this.toCheck.get(0);
        try {
            profile = server.func_147130_as().fillProfileProperties(profile, true);
            if (profile.getName() == null || profile.getId() == null) {
                return;
            }
            server.func_152358_ax().func_152649_a(profile);
        }
        catch (Exception e) {
            return;
        }
        this.toCheck.remove(0);
        if (profile.getId() != null) {
            this.checked.add(profile.getId());
        }
    }

    @SubscribeEvent
    public void login(PlayerEvent.PlayerLoggedInEvent evt) {
        EntityPlayer entityPlayer = evt.player;
        LandManager.LandTeam team = LandManager.getTeam((Entity)entityPlayer);
        team.lastSeen = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_82737_E();
    }

    @SubscribeEvent
    public void detonate(ExplosionEvent.Detonate evt) {
        if (evt.getWorld().field_72995_K) {
            return;
        }
        ArrayList toRemove = Lists.newArrayList();
        boolean denyBlasts = ConfigManager.INSTANCE.denyExplosions;
        if (ConfigManager.INSTANCE.landEnabled) {
            int dimension = evt.getWorld().field_73011_w.getDimension();
            for (BlockPos pos : evt.getAffectedBlocks()) {
                Coordinate c = Coordinate.getChunkCoordFromWorldCoord(pos, dimension);
                LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
                boolean deny = denyBlasts;
                if (owner == null) continue;
                boolean bl = deny = deny || owner.noExplosions;
                if (!deny) continue;
                toRemove.add(pos);
            }
        }
        evt.getAffectedBlocks().removeAll(toRemove);
    }

    public void onServerStarted() {
        LandSaveHandler.loadGlobalData();
    }

    public void onServerStopped() {
        LandManager.clearInstance();
    }

    private static void sendMessage(Entity player, LandManager.LandTeam team, byte index) {
        ITextComponent message = null;
        switch (index) {
            case 0: {
                message = LandEventsHandler.getDenyMessage(team);
                break;
            }
            case 1: {
                message = LandEventsHandler.getEnterMessage(team);
                break;
            }
            case 2: {
                message = LandEventsHandler.getExitMessage(team);
            }
        }
        if (message != null) {
            player.func_145747_a(message);
        }
    }

    private static ITextComponent getDenyMessage(LandManager.LandTeam team) {
        if (team != null && !team.denyMessage.isEmpty()) {
            return new TextComponentString(team.denyMessage);
        }
        if (!ConfigManager.INSTANCE.defaultMessages) {
            return null;
        }
        return new TextComponentTranslation("msg.team.deny", new Object[]{team.teamName});
    }

    private static ITextComponent getEnterMessage(LandManager.LandTeam team) {
        if (team != null && !team.enterMessage.isEmpty()) {
            return new TextComponentString(team.enterMessage);
        }
        if (!ConfigManager.INSTANCE.defaultMessages) {
            return null;
        }
        return new TextComponentTranslation("msg.team.enterLand", new Object[]{team.teamName});
    }

    private static ITextComponent getExitMessage(LandManager.LandTeam team) {
        if (team != null && !team.exitMessage.isEmpty()) {
            return new TextComponentString(team.exitMessage);
        }
        if (!ConfigManager.INSTANCE.defaultMessages) {
            return null;
        }
        return new TextComponentTranslation("msg.team.exitLand", new Object[]{team.teamName});
    }

    public static class ChunkLoadHandler {
        public static HashMap<Coordinate, ForgeChunkManager.Ticket> chunks = Maps.newHashMap();

        public static boolean removeChunks(Coordinate location) {
            ForgeChunkManager.Ticket ticket = chunks.remove(location);
            if (ticket != null) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                return true;
            }
            return false;
        }

        public static boolean addChunks(World world, Coordinate location, UUID placer) {
            if (!ConfigManager.INSTANCE.chunkLoading) {
                return false;
            }
            boolean found = chunks.containsKey(location);
            try {
                if (!found) {
                    ForgeChunkManager.Ticket ticket = ForgeChunkManager.requestPlayerTicket((Object)ThutEssentials.instance, (String)placer.toString(), (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                    int[] loc = new int[]{location.x, location.z};
                    ticket.getModData().func_74783_a("pos", loc);
                    ChunkPos chunk = new ChunkPos(location.x, location.z);
                    ThutEssentials.logger.log(Level.FINER, "Forcing Chunk at " + location);
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunk);
                    chunks.put(location, ticket);
                    return true;
                }
            }
            catch (Throwable e) {
                ThutEssentials.logger.log(Level.FINER, "Error adding chunks to load.", new Exception(e));
            }
            return false;
        }
    }

    public static class InteractEventHandler {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void interact(PlayerInteractEvent.LeftClickBlock evt) {
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            if (!ConfigManager.INSTANCE.landEnabled) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getEntityPlayer().func_130014_f_().field_73011_w.getDimension());
            Coordinate b = new Coordinate(evt.getPos(), evt.getEntityPlayer().func_130014_f_().field_73011_w.getDimension());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (owner == null) {
                return;
            }
            if (owner.fakePlayers && evt.getEntityPlayer() instanceof FakePlayer) {
                return;
            }
            Block block = evt.getWorld().func_180495_p(evt.getPos()).func_177230_c();
            String name = block.getRegistryName().toString();
            if (blockBreakWhiteList.contains(name)) {
                return;
            }
            if (owner.canUseStuff(evt.getEntityPlayer().func_110124_au(), b)) {
                return;
            }
            Coordinate blockLoc = new Coordinate(evt.getPos(), evt.getEntityPlayer().func_130014_f_().field_73011_w.getDimension());
            if (!LandManager.getInstance().isPublic(blockLoc, owner)) {
                evt.setUseBlock(Event.Result.DENY);
                evt.setCanceled(true);
                if (!evt.getWorld().field_72995_K) {
                    LandEventsHandler.sendMessage(evt.getEntity(), owner, (byte)0);
                }
                if (ConfigManager.INSTANCE.log_interactions) {
                    ThutEssentials.logger.log(Level.FINER, "Cancelled interact due to not allowed to left click that." + c + " " + evt.getEntityPlayer().func_110124_au() + " " + evt.getEntityPlayer().func_70005_c_());
                }
            }
            evt.setUseItem(Event.Result.DENY);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void interact(PlayerInteractEvent.EntityInteract evt) {
            if (evt.getSide() == Side.CLIENT) {
                return;
            }
            if (!ConfigManager.INSTANCE.landEnabled) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getEntityPlayer().func_130014_f_().field_73011_w.getDimension());
            Coordinate b = new Coordinate(evt.getPos(), evt.getEntityPlayer().func_130014_f_().field_73011_w.getDimension());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (owner == null) {
                return;
            }
            if (owner.fakePlayers && evt.getEntityPlayer() instanceof FakePlayer) {
                return;
            }
            if (owner.canUseStuff(evt.getEntityPlayer().func_110124_au(), b) && owner.isAdmin((Entity)evt.getEntityPlayer())) {
                if (evt.getTarget() instanceof EntityPlayer) {
                    return;
                }
                if (!evt.getWorld().field_72995_K && evt.getItemStack() != null && evt.getItemStack().func_82833_r().equals("Public Toggle") && evt.getEntityPlayer().func_70093_af()) {
                    if (owner.public_mobs.contains(evt.getTarget().func_110124_au())) {
                        evt.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("Removed from public: " + evt.getTarget().func_70005_c_()));
                        LandManager.getInstance().toggleMobPublic(evt.getTarget().func_110124_au(), owner);
                    } else {
                        evt.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("Added to Public: " + evt.getTarget().func_70005_c_()));
                        LandManager.getInstance().toggleMobPublic(evt.getTarget().func_110124_au(), owner);
                    }
                    evt.setCanceled(true);
                    if (ConfigManager.INSTANCE.log_interactions) {
                        ThutEssentials.logger.log(Level.FINER, "Cancelled interact due to toggling public mob." + c + " " + evt.getEntityPlayer().func_110124_au() + " " + evt.getEntityPlayer().func_70005_c_());
                    }
                    return;
                }
                if (!evt.getWorld().field_72995_K && evt.getItemStack() != null && evt.getItemStack().func_82833_r().equals("Protect Toggle") && evt.getEntityPlayer().func_70093_af() && PermissionAPI.hasPermission((EntityPlayer)evt.getEntityPlayer(), (String)LandEventsHandler.PERMPROTECTMOB)) {
                    if (owner.protected_mobs.contains(evt.getTarget().func_110124_au())) {
                        evt.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("Removed from protected: " + evt.getTarget().func_70005_c_()));
                        LandManager.getInstance().toggleMobProtect(evt.getTarget().func_110124_au(), owner);
                    } else {
                        evt.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("Added to protected: " + evt.getTarget().func_70005_c_()));
                        LandManager.getInstance().toggleMobProtect(evt.getTarget().func_110124_au(), owner);
                    }
                    evt.setCanceled(true);
                    if (ConfigManager.INSTANCE.log_interactions) {
                        ThutEssentials.logger.log(Level.FINER, "Cancelled interact due to toggling protected mob." + c + " " + evt.getEntityPlayer().func_110124_au() + " " + evt.getEntityPlayer().func_70005_c_());
                    }
                    return;
                }
            }
            if (owner.allPublic) {
                return;
            }
            if (owner.canUseStuff(evt.getEntityPlayer().func_110124_au(), b)) {
                return;
            }
            if (!owner.public_mobs.contains(evt.getTarget().func_110124_au())) {
                evt.setCanceled(true);
                if (ConfigManager.INSTANCE.log_interactions) {
                    ThutEssentials.logger.log(Level.FINER, "Cancelled interact due to not public mob." + c + " " + evt.getEntityPlayer().func_110124_au() + " " + evt.getEntityPlayer().func_70005_c_());
                }
                return;
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void interact(PlayerInteractEvent.RightClickItem evt) {
            if (evt.getSide() == Side.CLIENT) {
                return;
            }
            if (evt.getItemStack().func_77973_b() instanceof ItemFood || evt.getItemStack().func_77973_b() == Items.field_151164_bB || evt.getItemStack().func_77973_b() == Items.field_151099_bA || !ConfigManager.INSTANCE.landEnabled || evt.getEntity().field_70170_p.field_72995_K) {
                return;
            }
            EntityPlayer player = evt.getEntityPlayer();
            String name = evt.getItemStack().func_77973_b().getRegistryName().toString();
            if (itemUseWhitelist.contains(name)) {
                return;
            }
            if (MinecraftForge.EVENT_BUS.post((Event)new DenyItemUseEvent(evt.getEntity(), evt.getItemStack(), DenyItemUseEvent.UseType.RIGHTCLICKBLOCK))) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), player.func_130014_f_().field_73011_w.getDimension());
            Coordinate b = new Coordinate(evt.getPos(), player.func_130014_f_().field_73011_w.getDimension());
            boolean ownedLand = LandManager.getInstance().isOwned(c);
            if (!ownedLand) {
                if (PermissionAPI.hasPermission((EntityPlayer)player, (String)LandEventsHandler.PERMUSEITEMWILD)) {
                    return;
                }
                player.func_145747_a((ITextComponent)new TextComponentString("Cannot use that."));
                evt.setCanceled(true);
                ((EntityPlayerMP)player).func_71110_a(player.field_71069_bz, player.field_71069_bz.field_75153_a);
                return;
            }
            LandManager.LandTeam team = LandManager.getInstance().getLandOwner(c);
            if (team.allPublic) {
                return;
            }
            if (team.fakePlayers && evt.getEntityPlayer() instanceof FakePlayer) {
                return;
            }
            boolean owns = team.canUseStuff(player.func_110124_au(), b);
            String perm = owns ? LandEventsHandler.PERMUSEITEMOWN : LandEventsHandler.PERMUSEITEMOTHER;
            boolean permission = PermissionAPI.hasPermission((EntityPlayer)player, (String)perm);
            if (!permission) {
                LandEventsHandler.sendMessage((Entity)player, team, (byte)0);
                evt.setResult(Event.Result.DENY);
                evt.setCanceled(true);
                ((EntityPlayerMP)player).func_71110_a(player.field_71069_bz, player.field_71069_bz.field_75153_a);
                return;
            }
            if (owns) {
                return;
            }
            Coordinate blockLoc = new Coordinate(evt.getPos(), player.func_130014_f_().field_73011_w.getDimension());
            if (LandManager.getInstance().isPublic(blockLoc, team)) {
                evt.setResult(Event.Result.DENY);
                return;
            }
            LandEventsHandler.sendMessage((Entity)player, team, (byte)0);
            evt.setResult(Event.Result.DENY);
            evt.setCanceled(true);
            ((EntityPlayerMP)player).func_71110_a(player.field_71069_bz, player.field_71069_bz.field_75153_a);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void interact(PlayerInteractEvent.RightClickBlock evt) {
            if (evt.getSide() == Side.CLIENT) {
                return;
            }
            if (!ConfigManager.INSTANCE.landEnabled) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getEntityPlayer().func_130014_f_().field_73011_w.getDimension());
            Coordinate b = new Coordinate(evt.getPos(), evt.getEntityPlayer().func_130014_f_().field_73011_w.getDimension());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            EntityPlayer player = evt.getEntityPlayer();
            if (owner == null) {
                if (!PermissionAPI.hasPermission((EntityPlayer)player, (String)LandEventsHandler.PERMUSEBLOCKWILD)) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Cannot use that."));
                    evt.setCanceled(true);
                    evt.setUseBlock(Event.Result.DENY);
                    evt.setUseItem(Event.Result.DENY);
                    if (player.field_71069_bz != null && player.field_71071_by != null) {
                        ((EntityPlayerMP)player).func_71110_a(player.field_71069_bz, player.field_71069_bz.field_75153_a);
                    }
                    if (ConfigManager.INSTANCE.log_interactions) {
                        ThutEssentials.logger.log(Level.FINER, "Cancelled interact due to not allowed to use wild." + c + " " + evt.getEntityPlayer().func_110124_au() + " " + evt.getEntityPlayer().func_70005_c_());
                    }
                    return;
                }
                return;
            }
            if (owner.allPublic) {
                return;
            }
            Block block = null;
            IBlockState state = evt.getWorld().func_180495_p(evt.getPos());
            block = state.func_177230_c();
            String name = block.getRegistryName().toString();
            if (blockUseWhiteList.contains(name)) {
                return;
            }
            boolean shouldPass = true;
            if (owner.fakePlayers && evt.getEntityPlayer() instanceof FakePlayer) {
                return;
            }
            boolean owns = owner.canUseStuff(player.func_110124_au(), b);
            Coordinate blockLoc = new Coordinate(evt.getPos(), evt.getEntityPlayer().func_130014_f_().field_73011_w.getDimension());
            boolean freeuse = LandManager.getInstance().isPublic(blockLoc, owner);
            String perm = (owns = owns || freeuse) ? LandEventsHandler.PERMUSEBLOCKOWN : LandEventsHandler.PERMUSEBLOCKOTHER;
            boolean permission = PermissionAPI.hasPermission((EntityPlayer)player, (String)perm);
            if (!permission) {
                LandEventsHandler.sendMessage((Entity)player, owner, (byte)0);
                evt.setCanceled(true);
                evt.setUseBlock(Event.Result.DENY);
                evt.setUseItem(Event.Result.DENY);
                ((EntityPlayerMP)player).func_71110_a(player.field_71069_bz, player.field_71069_bz.field_75153_a);
                if (ConfigManager.INSTANCE.log_interactions) {
                    ThutEssentials.logger.log(Level.FINER, "Cancelled interact due to not allowed to use. owns?: " + owns + ", " + c + " " + evt.getEntityPlayer().func_110124_au() + " " + evt.getEntityPlayer().func_70005_c_());
                }
                return;
            }
            if (owns) {
                if (!evt.getWorld().field_72995_K && evt.getItemStack() != null && evt.getItemStack().func_82833_r().equals("Public Toggle") && evt.getEntityPlayer().func_70093_af() && !owner.allPublic && LandManager.getInstance().isAdmin(evt.getEntityPlayer().func_110124_au())) {
                    blockLoc = new Coordinate(evt.getPos(), evt.getEntityPlayer().func_130014_f_().field_73011_w.getDimension());
                    if (LandManager.getInstance().isPublic(blockLoc, owner)) {
                        evt.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("Set Block to Team Only"));
                        LandManager.getInstance().unsetPublic(blockLoc, owner);
                    } else {
                        evt.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("Set Block to Public Use"));
                        LandManager.getInstance().setPublic(blockLoc, owner);
                    }
                    evt.setCanceled(true);
                    if (ConfigManager.INSTANCE.log_interactions) {
                        ThutEssentials.logger.log(Level.FINER, "Cancelled interact due to public toggling. " + c + " " + evt.getEntityPlayer().func_110124_au() + " " + evt.getEntityPlayer().func_70005_c_());
                    }
                }
                if (!evt.getWorld().field_72995_K && evt.getItemStack() != null && evt.getItemStack().func_82833_r().equals("Break Toggle") && evt.getEntityPlayer().func_70093_af() && LandManager.getInstance().isAdmin(evt.getEntityPlayer().func_110124_au())) {
                    blockLoc = new Coordinate(evt.getPos(), evt.getEntityPlayer().func_130014_f_().field_73011_w.getDimension());
                    if (owner.anyBreakSet.contains(blockLoc)) {
                        evt.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("Set Block to Team Breaking Only"));
                        owner.anyBreakSet.remove(blockLoc);
                    } else {
                        evt.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("Set Block to Public Breaking"));
                        owner.anyBreakSet.add(blockLoc);
                    }
                    LandSaveHandler.saveTeam(owner.teamName);
                    evt.setCanceled(true);
                    if (ConfigManager.INSTANCE.log_interactions) {
                        ThutEssentials.logger.log(Level.FINER, "Cancelled interact due to break toggling. " + c + " " + evt.getEntityPlayer().func_110124_au() + " " + evt.getEntityPlayer().func_70005_c_());
                    }
                }
                if (!evt.getWorld().field_72995_K && evt.getItemStack() != null && evt.getItemStack().func_82833_r().equals("Place Toggle") && evt.getEntityPlayer().func_70093_af() && LandManager.getInstance().isAdmin(evt.getEntityPlayer().func_110124_au())) {
                    blockLoc = new Coordinate(evt.getPos(), evt.getEntityPlayer().func_130014_f_().field_73011_w.getDimension());
                    if (owner.anyPlaceSet.contains(blockLoc)) {
                        evt.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("Set Block to Team Placing Only"));
                        owner.anyPlaceSet.remove(blockLoc);
                    } else {
                        evt.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentString("Set Block to Public Placing"));
                        owner.anyPlaceSet.add(blockLoc);
                    }
                    LandSaveHandler.saveTeam(owner.teamName);
                    evt.setCanceled(true);
                    if (ConfigManager.INSTANCE.log_interactions) {
                        ThutEssentials.logger.log(Level.FINER, "Cancelled interact due to place toggling. " + c + " " + evt.getEntityPlayer().func_110124_au() + " " + evt.getEntityPlayer().func_70005_c_());
                    }
                }
                return;
            }
            if (!block.hasTileEntity(state) && !evt.getWorld().field_72995_K) {
                shouldPass = MinecraftForge.EVENT_BUS.post((Event)new DenyItemUseEvent(evt.getEntity(), evt.getItemStack(), DenyItemUseEvent.UseType.RIGHTCLICKBLOCK));
                name = evt.getItemStack().func_77973_b().getRegistryName().toString();
                shouldPass = shouldPass || itemUseWhitelist.contains(name);
                boolean interact = true;
                if (shouldPass) {
                    BlockPos pos = evt.getPos();
                    Vec3d vec = evt.getHitVec();
                    if (vec == null) {
                        vec = new Vec3d(0.0, 0.0, 0.0);
                    }
                    interact = CompatWrapper.interactWithBlock(block, evt.getWorld(), pos, state, evt.getEntityPlayer(), evt.getHand(), null, evt.getFace(), (float)vec.field_72450_a, (float)vec.field_72448_b, (float)vec.field_72449_c);
                }
                if (!interact && shouldPass) {
                    return;
                }
            }
            LandEventsHandler.sendMessage((Entity)player, owner, (byte)0);
            evt.setCanceled(true);
            evt.setUseBlock(Event.Result.DENY);
            evt.setUseItem(Event.Result.DENY);
            ((EntityPlayerMP)player).func_71110_a(player.field_71069_bz, player.field_71069_bz.field_75153_a);
            if (ConfigManager.INSTANCE.log_interactions) {
                ThutEssentials.logger.log(Level.FINER, "Cancelled interact due to not allowed to use block." + c + " " + evt.getEntityPlayer().func_110124_au() + " " + evt.getEntityPlayer().func_70005_c_());
            }
        }
    }

    public static class EntityEventHandler {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void death(LivingDeathEvent evt) {
            LandManager.LandTeam team;
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            if (!ConfigManager.INSTANCE.landEnabled) {
                return;
            }
            UUID id = evt.getEntity().func_110124_au();
            if (LandManager.getInstance()._protected_mobs.containsKey(id)) {
                team = LandManager.getInstance()._protected_mobs.remove(id);
                team.protected_mobs.remove(id);
                LandSaveHandler.saveTeam(team.teamName);
            }
            if (LandManager.getInstance()._public_mobs.containsKey(id)) {
                team = LandManager.getInstance()._public_mobs.remove(id);
                team.public_mobs.remove(id);
                LandSaveHandler.saveTeam(team.teamName);
            }
        }

        @SubscribeEvent
        public void update(LivingEvent.LivingUpdateEvent evt) {
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            if (!ConfigManager.INSTANCE.landEnabled) {
                return;
            }
            if (evt.getEntityLiving() instanceof EntityPlayerMP && evt.getEntityLiving().field_70173_aa > 10) {
                Coordinate oldChunk;
                EntityPlayerMP player = (EntityPlayerMP)evt.getEntityLiving();
                BlockPos here = new BlockPos(player.field_71094_bP, player.field_71095_bQ, player.field_71085_bR);
                BlockPos old = new BlockPos(player.field_71091_bM, player.field_71096_bN, player.field_71097_bO);
                Coordinate newChunk = Coordinate.getChunkCoordFromWorldCoord(here, player.func_130014_f_().field_73011_w.getDimension());
                if (newChunk.equals(oldChunk = Coordinate.getChunkCoordFromWorldCoord(old, player.func_130014_f_().field_73011_w.getDimension())) || !ConfigManager.INSTANCE.landEnabled) {
                    return;
                }
                boolean isNewOwned = LandManager.getInstance().isOwned(newChunk);
                boolean isOldOwned = LandManager.getInstance().isOwned(oldChunk);
                if (isNewOwned || isOldOwned) {
                    boolean owns;
                    LandManager.LandTeam team = LandManager.getInstance().getLandOwner(newChunk);
                    LandManager.LandTeam team1 = LandManager.getInstance().getLandOwner(oldChunk);
                    if (!lastLeaveMessage.containsKey(evt.getEntity().func_110124_au())) {
                        lastLeaveMessage.put(evt.getEntity().func_110124_au(), System.currentTimeMillis() - 1L);
                    }
                    if (!lastEnterMessage.containsKey(evt.getEntity().func_110124_au())) {
                        lastEnterMessage.put(evt.getEntity().func_110124_au(), System.currentTimeMillis() - 1L);
                    }
                    if (!isNewOwned && !PermissionAPI.hasPermission((EntityPlayer)player, (String)LandEventsHandler.PERMENTERWILD)) {
                        player.field_71135_a.func_147364_a((double)old.func_177958_n() + 0.5, (double)old.func_177956_o(), (double)old.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
                        evt.getEntity().func_145747_a((ITextComponent)new TextComponentString("You may not enter there."));
                        return;
                    }
                    boolean bl = owns = team != null && team.isMember((Entity)player);
                    if (isNewOwned && owns && !PermissionAPI.hasPermission((EntityPlayer)player, (String)LandEventsHandler.PERMENTEROWN)) {
                        player.field_71135_a.func_147364_a((double)old.func_177958_n() + 0.5, (double)old.func_177956_o(), (double)old.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
                        evt.getEntity().func_145747_a((ITextComponent)new TextComponentString("You may not enter there."));
                        return;
                    }
                    if (isNewOwned && !owns && !PermissionAPI.hasPermission((EntityPlayer)player, (String)LandEventsHandler.PERMENTEROTHER)) {
                        player.field_71135_a.func_147364_a((double)old.func_177958_n() + 0.5, (double)old.func_177956_o(), (double)old.func_177952_p() + 0.5, player.field_70177_z, player.field_70125_A);
                        evt.getEntity().func_145747_a((ITextComponent)new TextComponentString("You may not enter there."));
                        return;
                    }
                    if (team != null) {
                        if (!team.equals(team1)) {
                            long last;
                            if (team1 != null && (last = lastLeaveMessage.get(evt.getEntity().func_110124_au()).longValue()) < System.currentTimeMillis()) {
                                LandEventsHandler.sendMessage((Entity)player, team1, (byte)2);
                                lastLeaveMessage.put(evt.getEntity().func_110124_au(), System.currentTimeMillis() + 100L);
                            }
                            if ((last = lastEnterMessage.get(evt.getEntity().func_110124_au()).longValue()) < System.currentTimeMillis()) {
                                LandEventsHandler.sendMessage((Entity)player, team, (byte)1);
                                lastLeaveMessage.put(evt.getEntity().func_110124_au(), System.currentTimeMillis() + 100L);
                            }
                        }
                    } else {
                        long last = lastLeaveMessage.get(evt.getEntity().func_110124_au());
                        if (last < System.currentTimeMillis()) {
                            LandEventsHandler.sendMessage((Entity)player, team1, (byte)2);
                            lastLeaveMessage.put(evt.getEntity().func_110124_au(), System.currentTimeMillis() + 100L);
                        }
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void attack(AttackEntityEvent evt) {
            if (evt.getEntity().func_130014_f_().field_72995_K || !ConfigManager.INSTANCE.landEnabled) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getTarget().func_180425_c(), evt.getEntityPlayer().func_130014_f_().field_73011_w.getDimension());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (owner == null) {
                return;
            }
            if (evt.getTarget() instanceof EntityPlayer && owner.noPlayerDamage) {
                evt.setCanceled(true);
                return;
            }
            EntityPlayer attacker = evt.getEntityPlayer();
            if (owner.fakePlayers && evt.getEntityPlayer() instanceof FakePlayer) {
                return;
            }
            BlockPos pos = evt.getTarget().func_180425_c();
            Coordinate b = Coordinate.getChunkCoordFromWorldCoord(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), attacker.field_71093_bK);
            if (evt.getTarget() instanceof EntityItemFrame && !owner.canBreakBlock(attacker.func_110124_au(), b)) {
                evt.setCanceled(true);
                return;
            }
            if (owner.protected_mobs.contains(evt.getTarget().func_110124_au())) {
                evt.setCanceled(true);
                return;
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void attack(LivingAttackEvent evt) {
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            if (!ConfigManager.INSTANCE.landEnabled) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getEntity().func_180425_c(), evt.getEntity().func_130014_f_().field_73011_w.getDimension());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (owner == null) {
                return;
            }
            if (evt.getEntity() instanceof EntityPlayer) {
                Entity damageSource;
                LandManager.LandTeam players = LandManager.getTeam(evt.getEntity());
                if (!players.friendlyFire && (damageSource = evt.getSource().func_76346_g()) instanceof EntityPlayer && LandEventsHandler.sameTeam(damageSource, evt.getEntity())) {
                    evt.setCanceled(true);
                    return;
                }
                if (owner.noPlayerDamage) {
                    evt.setCanceled(true);
                    return;
                }
            }
            if (owner.fakePlayers && evt.getSource().func_76346_g() instanceof FakePlayer) {
                return;
            }
            if (owner.protected_mobs.contains(evt.getEntity().func_110124_au())) {
                evt.setCanceled(true);
                return;
            }
        }

        @SubscribeEvent
        public void projectileImpact(ProjectileImpactEvent evt) {
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            if (!ConfigManager.INSTANCE.shopsEnabled) {
                return;
            }
            if (evt.getRayTraceResult() == null) {
                return;
            }
            if (evt.getRayTraceResult().field_72308_g == null) {
                return;
            }
            Entity target = evt.getRayTraceResult().field_72308_g;
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getEntity().func_180425_c(), evt.getEntity().func_130014_f_().field_73011_w.getDimension());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (owner == null) {
                return;
            }
            if (owner.noPlayerDamage && target instanceof EntityPlayer) {
                evt.setCanceled(true);
                return;
            }
            if (target instanceof EntityItemFrame && owner.protectFrames) {
                evt.setCanceled(true);
                return;
            }
            if (owner.protected_mobs.contains(target.func_110124_au())) {
                evt.setCanceled(true);
                return;
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void attack(LivingHurtEvent evt) {
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            if (!ConfigManager.INSTANCE.landEnabled) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getEntity().func_180425_c(), evt.getEntity().func_130014_f_().field_73011_w.getDimension());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (owner == null) {
                return;
            }
            if (owner.noPlayerDamage && evt.getEntity() instanceof EntityPlayer) {
                evt.setCanceled(true);
                return;
            }
            if (owner.protected_mobs.contains(evt.getEntity().func_110124_au())) {
                evt.setCanceled(true);
                return;
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void spawn(LivingSpawnEvent.SpecialSpawn evt) {
            if (!ConfigManager.INSTANCE.landEnabled) {
                return;
            }
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getEntity().func_180425_c(), evt.getEntity().func_130014_f_().field_73011_w.getDimension());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (owner == null) {
                return;
            }
            if (owner.noMobSpawn) {
                evt.setResult(Event.Result.DENY);
                return;
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void spawn(LivingSpawnEvent.CheckSpawn evt) {
            if (!ConfigManager.INSTANCE.landEnabled) {
                return;
            }
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getEntity().func_180425_c(), evt.getEntity().func_130014_f_().field_73011_w.getDimension());
            LandManager.LandTeam owner = LandManager.getInstance().getLandOwner(c);
            if (owner == null) {
                return;
            }
            if (owner.noMobSpawn) {
                evt.setResult(Event.Result.DENY);
                return;
            }
        }
    }

    public static class BlockEventHandler {
        public void checkPlace(BlockEvent evt, EntityPlayer player) {
            if (!(player instanceof EntityPlayerMP)) {
                return;
            }
            String name = evt.getWorld().func_180495_p(evt.getPos()).func_177230_c().getRegistryName().toString();
            if (blockPlaceWhiteList.contains(name)) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), player.func_130014_f_().field_73011_w.getDimension());
            Coordinate b = new Coordinate(evt.getPos(), player.func_130014_f_().field_73011_w.getDimension());
            LandManager.LandTeam team = LandManager.getInstance().getLandOwner(c);
            if (team == null) {
                if (PermissionAPI.hasPermission((EntityPlayer)player, (String)LandEventsHandler.PERMPLACEWILD)) {
                    return;
                }
                player.func_145747_a((ITextComponent)new TextComponentString("Cannot place that."));
                evt.setCanceled(true);
                ((EntityPlayerMP)player).func_71110_a(player.field_71069_bz, player.field_71069_bz.field_75153_a);
                return;
            }
            if (!team.fakePlayers || !(player instanceof FakePlayer)) {
                boolean owns = team.canPlaceBlock(player.func_110124_au(), b);
                if (owns && !PermissionAPI.hasPermission((EntityPlayer)player, (String)LandEventsHandler.PERMPLACEOWN)) {
                    LandEventsHandler.sendMessage((Entity)player, team, (byte)0);
                    evt.setCanceled(true);
                    ((EntityPlayerMP)player).func_71110_a(player.field_71069_bz, player.field_71069_bz.field_75153_a);
                    return;
                }
                if (!owns && !PermissionAPI.hasPermission((EntityPlayer)player, (String)LandEventsHandler.PERMPLACEOTHER)) {
                    LandEventsHandler.sendMessage((Entity)player, team, (byte)0);
                    evt.setCanceled(true);
                    ((EntityPlayerMP)player).func_71110_a(player.field_71069_bz, player.field_71069_bz.field_75153_a);
                    return;
                }
            }
        }

        public void checkBreak(BlockEvent evt, EntityPlayer player) {
            if (ConfigManager.INSTANCE.landEnabled && player != null) {
                String name = evt.getWorld().func_180495_p(evt.getPos()).func_177230_c().getRegistryName().toString();
                if (blockBreakWhiteList.contains(name)) {
                    return;
                }
                Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), player.func_130014_f_().field_73011_w.getDimension());
                Coordinate b = new Coordinate(evt.getPos(), player.func_130014_f_().field_73011_w.getDimension());
                LandManager.LandTeam team = LandManager.getInstance().getLandOwner(c);
                if (team == null) {
                    if (PermissionAPI.hasPermission((EntityPlayer)player, (String)LandEventsHandler.PERMBREAKWILD)) {
                        return;
                    }
                    player.func_145747_a((ITextComponent)new TextComponentString("Cannot break that."));
                    evt.setCanceled(true);
                    return;
                }
                if (!team.fakePlayers || !(player instanceof FakePlayer)) {
                    boolean owns = team.canBreakBlock(player.func_110124_au(), b);
                    if (owns && !PermissionAPI.hasPermission((EntityPlayer)player, (String)LandEventsHandler.PERMBREAKOWN)) {
                        LandEventsHandler.sendMessage((Entity)player, team, (byte)0);
                        evt.setCanceled(true);
                        return;
                    }
                    if (!owns && !PermissionAPI.hasPermission((EntityPlayer)player, (String)LandEventsHandler.PERMBREAKOTHER)) {
                        LandEventsHandler.sendMessage((Entity)player, team, (byte)0);
                        evt.setCanceled(true);
                        return;
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void trample(BlockEvent.FarmlandTrampleEvent evt) {
            if (evt.getEntity().func_130014_f_().field_72995_K) {
                return;
            }
            if (!ConfigManager.INSTANCE.landEnabled) {
                return;
            }
            Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getWorld().field_73011_w.getDimension());
            Entity trampler = evt.getEntity();
            LandManager.LandTeam team = LandManager.getInstance().getLandOwner(c);
            if (team == null) {
                return;
            }
            EntityPlayer player = null;
            if (trampler instanceof EntityPlayer) {
                player = (EntityPlayer)trampler;
            }
            if (trampler instanceof IEntityOwnable && ((IEntityOwnable)trampler).func_70902_q() instanceof EntityPlayer) {
                player = (EntityPlayer)((IEntityOwnable)trampler).func_70902_q();
            }
            this.checkBreak((BlockEvent)evt, player);
            if (!evt.isCanceled() && ThutEssentials.instance.config.log_interactions) {
                ThutEssentials.logger.log(Level.FINER, c + " trample " + evt.getPos() + " " + trampler.func_110124_au() + " " + trampler.func_70005_c_());
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void placeBlocks(BlockEvent.PlaceEvent evt) {
            if (evt.getPlayer().func_130014_f_().field_72995_K) {
                return;
            }
            if (!ConfigManager.INSTANCE.landEnabled) {
                return;
            }
            this.checkPlace((BlockEvent)evt, evt.getPlayer());
            if (!evt.isCanceled() && ThutEssentials.instance.config.log_interactions) {
                Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getWorld().field_73011_w.getDimension());
                ThutEssentials.logger.log(Level.FINER, c + " place " + evt.getPos() + " " + evt.getPlacedAgainst() + " " + evt.getPlacedBlock() + " " + evt.getPlayer().func_110124_au() + " " + evt.getPlayer().func_70005_c_());
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void BreakBlock(BlockEvent.BreakEvent evt) {
            if (evt.getPlayer().func_130014_f_().field_72995_K) {
                return;
            }
            if (!ConfigManager.INSTANCE.landEnabled) {
                return;
            }
            EntityPlayer player = evt.getPlayer();
            this.checkBreak((BlockEvent)evt, player);
            if (!evt.isCanceled() && ThutEssentials.instance.config.log_interactions) {
                Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getWorld().field_73011_w.getDimension());
                ThutEssentials.logger.log(Level.FINER, c + " break " + evt.getPos() + " " + evt.getState() + " " + evt.getPlayer().func_110124_au() + " " + evt.getPlayer().func_70005_c_());
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public void bucket(FillBucketEvent event) {
            if (event.getEntityPlayer().func_130014_f_().field_72995_K) {
                return;
            }
            if (!ConfigManager.INSTANCE.landEnabled) {
                return;
            }
            BlockPos pos = event.getEntityPlayer().func_180425_c();
            if (event.getTarget() != null) {
                pos = event.getTarget().func_178782_a().func_177972_a(event.getTarget().field_178784_b);
            }
            EntityPlayer player = event.getEntityPlayer();
            BlockEvent.BreakEvent evt = new BlockEvent.BreakEvent(event.getWorld(), pos, event.getWorld().func_180495_p(pos), player);
            this.checkPlace((BlockEvent)evt, player);
            this.checkBreak((BlockEvent)evt, player);
            if (evt.isCanceled()) {
                event.setCanceled(true);
            } else if (ThutEssentials.instance.config.log_interactions) {
                Coordinate c = Coordinate.getChunkCoordFromWorldCoord(evt.getPos(), evt.getWorld().field_73011_w.getDimension());
                ThutEssentials.logger.log(Level.FINER, c + " bucket " + evt.getPos() + " " + player.func_110124_au() + " " + player.func_70005_c_() + " " + event.getFilledBucket() + " " + event.getEmptyBucket());
            }
        }
    }
}

