/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.land;

import com.google.common.collect.Lists;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.FileUtils;
import thut.essentials.ThutEssentials;
import thut.essentials.land.LandManager;
import thut.essentials.util.ConfigManager;
import thut.essentials.util.Coordinate;

public class LandSaveHandler {
    public static Gson SAVE_GSON = null;
    public static Gson LOAD_GSON = null;
    static ExclusionStrategy exclusion = new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes f) {
            String name = f.getName();
            return name.startsWith("_");
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    };

    public static void removeEmptyTeams() {
        HashSet<String> toRemove = new HashSet<String>();
        HashMap<String, LandManager.LandTeam> teamMap = LandManager.getInstance()._teamMap;
        for (String s : teamMap.keySet()) {
            LandManager.LandTeam team = (LandManager.LandTeam)teamMap.get(s);
            if (team.member.size() != 0 || team.reserved || team == LandManager.getDefaultTeam()) continue;
            toRemove.add(s);
        }
        for (String s : toRemove) {
            LandManager.getInstance().removeTeam(s);
        }
    }

    public static File getGlobalFolder() {
        String folder = FMLCommonHandler.instance().getMinecraftServerInstance().func_71270_I();
        File file = FMLCommonHandler.instance().getSavesDirectory();
        File saveFolder = new File(file, folder);
        File teamsFolder = new File(saveFolder, "land");
        if (!teamsFolder.exists()) {
            teamsFolder.mkdirs();
        }
        return teamsFolder;
    }

    public static File getTeamFolder() {
        File teamFolder = new File(LandSaveHandler.getGlobalFolder(), "teams");
        if (!teamFolder.exists()) {
            teamFolder.mkdirs();
        }
        return teamFolder;
    }

    public static void saveGlobalData() {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            return;
        }
        if (SAVE_GSON == null) {
            SAVE_GSON = new GsonBuilder().addSerializationExclusionStrategy(exclusion).setPrettyPrinting().create();
        }
        LandManager.getInstance().version = 1;
        String json = SAVE_GSON.toJson((Object)LandManager.getInstance());
        File teamsFile = new File(LandSaveHandler.getGlobalFolder(), "landData.json");
        try {
            FileUtils.writeStringToFile((File)teamsFile, (String)json, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadGlobalData() {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            return;
        }
        if (LOAD_GSON == null) {
            LOAD_GSON = new GsonBuilder().addDeserializationExclusionStrategy(exclusion).setPrettyPrinting().create();
        }
        File teamsFile = new File(LandSaveHandler.getGlobalFolder(), "landData.json");
        if (ConfigManager.INSTANCE.debug) {
            ThutEssentials.logger.log(Level.INFO, "Starting Loading Land");
        }
        if (teamsFile.exists()) {
            try {
                String json = FileUtils.readFileToString((File)teamsFile, (String)"UTF-8");
                LandManager.instance = (LandManager)LOAD_GSON.fromJson(json, LandManager.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (LandManager.instance == null) {
                LandManager.instance = new LandManager();
            }
            LandSaveHandler.loadTeams();
        } else {
            if (LandManager.instance == null) {
                LandManager.instance = new LandManager();
            }
            LandSaveHandler.saveGlobalData();
        }
        if (ConfigManager.INSTANCE.debug) {
            ThutEssentials.logger.log(Level.INFO, "Finished Loading Land and Teams");
        }
        LandManager.getDefaultTeam().reserved = true;
    }

    private static void loadTeams() {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            return;
        }
        if (LOAD_GSON == null) {
            LOAD_GSON = new GsonBuilder().addDeserializationExclusionStrategy(exclusion).setPrettyPrinting().create();
        }
        File folder = LandSaveHandler.getTeamFolder();
        if (ConfigManager.INSTANCE.debug) {
            ThutEssentials.logger.log(Level.INFO, "Starting Loading Teams");
        }
        for (File file : folder.listFiles()) {
            try {
                String json = FileUtils.readFileToString((File)file, (String)"UTF-8");
                LandManager.LandTeam team = (LandManager.LandTeam)LOAD_GSON.fromJson(json, LandManager.LandTeam.class);
                LandManager.getInstance()._teamMap.put(team.teamName, team);
                team.init(FMLCommonHandler.instance().getMinecraftServerInstance());
                ArrayList toAdd = Lists.newArrayList(team.land.land);
                if (ConfigManager.INSTANCE.debug) {
                    ThutEssentials.logger.log(Level.FINER, "Processing " + team.teamName);
                }
                for (Coordinate land : toAdd) {
                    LandManager.getInstance().addTeamLand(team.teamName, land, false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (ConfigManager.INSTANCE.debug) {
            ThutEssentials.logger.log(Level.INFO, "Cleaning Up Teams");
        }
        LandSaveHandler.removeEmptyTeams();
    }

    public static void saveTeam(String team) {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() == null) {
            return;
        }
        if (SAVE_GSON == null) {
            SAVE_GSON = new GsonBuilder().addSerializationExclusionStrategy(exclusion).setPrettyPrinting().create();
        }
        File folder = LandSaveHandler.getTeamFolder();
        File teamFile = new File(folder, team + ".json");
        LandManager.LandTeam land = LandManager.getInstance().getTeam(team, false);
        if (land != null) {
            if (land == LandManager.getDefaultTeam()) {
                land.member.clear();
            }
            String json = SAVE_GSON.toJson((Object)land);
            try {
                FileUtils.writeStringToFile((File)teamFile, (String)json, (String)"UTF-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void deleteTeam(String team) {
        File folder = LandSaveHandler.getTeamFolder();
        File teamFile = new File(folder, team + ".json");
        if (teamFile.exists()) {
            teamFile.delete();
        }
    }
}

