/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSenderWrapper;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListOpsEntry;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import thut.essentials.ThutEssentials;
import thut.essentials.commands.CommandManager;

public abstract class BaseCommand
extends CommandBase {
    static final Map<String, Integer> permsMap = Maps.newHashMap();
    public final String key;
    final int perm;

    public static EntityPlayerMP getPlayerBySender(ICommandSender sender) throws CommandException {
        if (sender instanceof EntityPlayerMP) {
            return (EntityPlayerMP)sender;
        }
        if (sender instanceof CommandSenderWrapper) {
            return CommandBase.func_184888_a((MinecraftServer)sender.func_184102_h(), (ICommandSender)sender, (String)sender.func_70005_c_());
        }
        throw new CommandException("No Player Found", new Object[0]);
    }

    public static GameProfile getProfile(MinecraftServer server, UUID id) {
        GameProfile profile = null;
        if (id != null) {
            profile = server.func_152358_ax().func_152652_a(id);
        }
        if (profile == null) {
            profile = new GameProfile(id, null);
        }
        ThutEssentials.instance.teams.queueUpdate(profile);
        return profile;
    }

    public static GameProfile getProfile(MinecraftServer server, String arg) {
        UUID id = null;
        String name = null;
        try {
            id = UUID.fromString(arg);
        }
        catch (Exception e) {
            name = arg;
        }
        GameProfile profile = null;
        if (id != null) {
            profile = server.func_152358_ax().func_152652_a(id);
        }
        if (profile == null) {
            profile = new GameProfile(id, name);
        }
        ThutEssentials.instance.teams.queueUpdate(profile);
        if (profile.getId() == null) {
            EntityPlayerMP player = server.func_184103_al().func_152612_a(profile.getName());
            profile = player.func_146103_bH();
        }
        return profile;
    }

    public BaseCommand(String key, int perms, String ... aliases) {
        this.key = key;
        ArrayList alii = CommandManager.commands.get(key);
        if (alii == null || alii.isEmpty()) {
            alii = Lists.newArrayList((Object[])new String[]{key});
            CommandManager.commands.put(key, alii);
        }
        for (String s : aliases) {
            if (alii.contains(s)) continue;
            alii.add(s);
        }
        if (!alii.contains(key.toLowerCase(Locale.ENGLISH))) {
            alii.add(key.toLowerCase(Locale.ENGLISH));
        }
        this.perm = this.getPermissionLevel(perms);
    }

    private int getPermissionLevel(int deault_) {
        if (permsMap.containsKey(this.key)) {
            return permsMap.get(this.key);
        }
        for (String s : this.func_71514_a()) {
            if (!permsMap.containsKey(s)) continue;
            return permsMap.get(s);
        }
        return deault_;
    }

    public int func_82362_a() {
        return this.perm;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        if (!(sender instanceof EntityPlayer) || !server.func_71262_S()) {
            return true;
        }
        EntityPlayerMP player = null;
        try {
            player = BaseCommand.func_71521_c((ICommandSender)sender);
        }
        catch (PlayerNotFoundException e) {
            return false;
        }
        if (server.func_184103_al().func_152596_g(player.func_146103_bH())) {
            return true;
        }
        UserListOpsEntry userlistopsentry = (UserListOpsEntry)server.func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH());
        return userlistopsentry != null ? userlistopsentry.func_152644_a() >= this.perm : this.perm <= 0;
    }

    public String func_71517_b() {
        if (CommandManager.commands.get(this.key) == null) {
            return this.key;
        }
        return CommandManager.commands.get(this.key).get(0);
    }

    public String func_71518_a(ICommandSender sender) {
        return "/" + this.func_71517_b();
    }

    public List<String> func_71514_a() {
        if (CommandManager.commands.get(this.key) != null) {
            return CommandManager.commands.get(this.key);
        }
        return Collections.emptyList();
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        int last = args.length - 1;
        if (last >= 0 && this.func_82358_a(args, last)) {
            return BaseCommand.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return Collections.emptyList();
    }

    public void destroy() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }
}

