/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.PlayerContext;
import thut.essentials.events.NameEvent;
import thut.essentials.land.LandManager;
import thut.essentials.util.ConfigManager;
import thut.essentials.util.PlayerDataHandler;
import thut.essentials.util.RuleManager;

public class ChatHandler {
    public static final String CANFORMAT = "thutessentials.chat.format";

    public ChatHandler() {
        PermissionAPI.registerNode((String)CANFORMAT, (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Will messages sent by the player using & codes be converted to text formats, use \\& to bypass. This requires forceChatFormat true in configs.");
    }

    @SubscribeEvent
    public void chatEvent(ServerChatEvent event) {
        Object message;
        if (!ConfigManager.INSTANCE.forceChatFormat) {
            return;
        }
        String format = ConfigManager.INSTANCE.chatFormat;
        String userName = event.getPlayer().getDisplayNameString();
        Iterator iter = event.getComponent().iterator();
        TextComponentString name = null;
        boolean found = false;
        ArrayList text = Lists.newArrayList();
        ArrayList styles = Lists.newArrayList();
        while (iter.hasNext()) {
            ITextComponent temp = (ITextComponent)iter.next();
            text.add(temp.func_150261_e());
            styles.add(temp.func_150256_b());
            if (!temp.func_150260_c().equals(userName)) continue;
            Style style = temp.func_150256_b();
            name = new TextComponentString(userName);
            name.func_150255_a(style);
            found = true;
        }
        IPermissionHandler manager = PermissionAPI.getPermissionHandler();
        boolean canFormat = manager.hasPermission(event.getPlayer().func_146103_bH(), CANFORMAT, (IContext)new PlayerContext((EntityPlayer)event.getPlayer()));
        if (found && text.size() > 3) {
            message = new TextComponentString("");
            for (int i = 4; i < text.size(); ++i) {
                String segment = (String)text.get(i);
                if (manager.hasPermission(event.getPlayer().func_146103_bH(), CANFORMAT, (IContext)new PlayerContext((EntityPlayer)event.getPlayer()))) {
                    segment = RuleManager.format(segment);
                }
                TextComponentString part = new TextComponentString(segment);
                part.func_150255_a((Style)styles.get(i));
                message.func_150257_a((ITextComponent)part);
            }
            String[] vars = format.split("\\[name\\]");
            if (vars.length == 2) {
                if (canFormat) {
                    vars[0] = RuleManager.format(vars[0]);
                }
                TextComponentString toSend = new TextComponentString(vars[0]);
                toSend.func_150257_a((ITextComponent)name);
                vars = vars[1].split("\\[message\\]");
                if (canFormat) {
                    for (int i = 0; i < vars.length; ++i) {
                        vars[i] = RuleManager.format(vars[i]);
                    }
                }
                TextComponentString newMessage = new TextComponentString(vars[0]);
                newMessage.func_150257_a((ITextComponent)message);
                if (vars.length == 2) {
                    newMessage.func_150257_a((ITextComponent)new TextComponentString(vars[1]));
                }
                toSend.func_150257_a((ITextComponent)newMessage);
                event.setComponent((ITextComponent)toSend);
                return;
            }
        }
        message = format.replace("[name]", TextFormatting.RESET + userName + TextFormatting.RESET);
        String mess = event.getMessage();
        if (canFormat) {
            mess = RuleManager.format(mess);
        }
        message = ((String)message).replace("[message]", mess);
        event.setComponent((ITextComponent)new TextComponentString((String)message));
    }

    @SubscribeEvent
    public void getDisplayNameEvent(PlayerEvent.NameFormat event) {
        String displayName = event.getDisplayname();
        NBTTagCompound tag = PlayerDataHandler.getCustomDataTag(event.getEntityPlayer());
        NBTTagCompound nametag = tag.func_74775_l("name");
        if (nametag.func_74764_b("name") && ConfigManager.INSTANCE.name) {
            displayName = nametag.func_74779_i("name");
        }
        if (nametag.func_74764_b("prefix") && ConfigManager.INSTANCE.prefix && !nametag.func_74779_i("prefix").trim().isEmpty()) {
            displayName = nametag.func_74779_i("prefix") + " " + displayName;
        }
        if (nametag.func_74764_b("suffix") && ConfigManager.INSTANCE.suffix && !nametag.func_74779_i("suffix").trim().isEmpty()) {
            displayName = displayName + " " + nametag.func_74779_i("suffix");
        }
        if (ConfigManager.INSTANCE.landEnabled) {
            String rankPrefix;
            LandManager.LandTeam team = LandManager.getTeam(event.getEntity());
            LandManager.PlayerRank rank = team._ranksMembers.get(event.getEntity().func_110124_au());
            if (rank != null && (rankPrefix = rank.prefix) != null) {
                displayName = rankPrefix + TextFormatting.RESET + " " + displayName;
            }
            if (!team.prefix.isEmpty()) {
                displayName = team.prefix + TextFormatting.RESET + " " + displayName;
            }
        }
        NameEvent event1 = new NameEvent(event.getEntityPlayer(), displayName);
        MinecraftForge.EVENT_BUS.post((Event)event1);
        event.setDisplayname(event1.getName());
    }
}

