/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class CompatWrapper {
    public static final ItemStack nullStack = ItemStack.field_190927_a;

    public static ItemStack fromTag(NBTTagCompound tag) {
        return new ItemStack(tag);
    }

    public static ItemStack copy(ItemStack in) {
        return in.func_77946_l();
    }

    public static Entity createEntity(World world, String in) {
        return EntityList.func_188429_b((ResourceLocation)new ResourceLocation(in), (World)world);
    }

    public static Entity createEntity(World world, ResourceLocation in) {
        return EntityList.func_188429_b((ResourceLocation)in, (World)world);
    }

    public static Entity createEntity(World world, Entity in) {
        return EntityList.func_188429_b((ResourceLocation)EntityList.func_191301_a((Entity)in), (World)world);
    }

    public static void moveEntitySelf(Entity in, double x, double y, double z) {
        in.func_70091_d(MoverType.SELF, x, y, z);
    }

    public static void sendChatMessage(ICommandSender to, ITextComponent message) {
        to.func_145747_a(message);
    }

    public static void registerModEntity(Class<? extends Entity> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        ResourceLocation regisrtyName = entityName.contains(":") ? new ResourceLocation(entityName) : new ResourceLocation(mc.getModId(), entityName);
        EntityRegistry.registerModEntity((ResourceLocation)regisrtyName, entityClass, (String)entityName, (int)id, (Object)mod, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
    }

    public static ItemStack setStackSize(ItemStack stack, int amount) {
        stack.func_190920_e(amount);
        return stack;
    }

    public static int getStackSize(ItemStack stack) {
        return stack.func_190916_E();
    }

    public static boolean isValid(ItemStack stack) {
        if (stack == null) {
            System.err.println("Stacks should not be null!");
            Thread.dumpStack();
            return false;
        }
        return CompatWrapper.getStackSize(stack) > 0;
    }

    public static ItemStack validate(ItemStack in) {
        if (in == null || !CompatWrapper.isValid(in)) {
            return nullStack;
        }
        return in;
    }

    public static void setAnimationToGo(ItemStack stack, int num) {
        stack.func_190915_d(num);
    }

    public static int increment(ItemStack in, int amt) {
        in.func_190917_f(amt);
        return in.func_190916_E();
    }

    public static List<ItemStack> makeList(int size) {
        return NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    public static void rightClickWith(ItemStack stack, EntityPlayer player, EnumHand hand) {
        ItemStack old = player.func_184586_b(hand);
        player.func_184611_a(hand, stack);
        stack.func_77973_b().func_77659_a(player.field_70170_p, player, hand);
        player.func_184611_a(hand, old);
    }

    public static NBTTagCompound getTag(ItemStack stack, String name, boolean create) {
        NBTTagCompound ret = stack.func_179543_a(name);
        if (ret == null) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            ret = new NBTTagCompound();
            stack.func_77978_p().func_74782_a(name, (NBTBase)ret);
        }
        return ret;
    }

    public static void processInitialInteract(Entity in, EntityPlayer player, EnumHand hand, ItemStack stack) {
        in.func_184230_a(player, hand);
    }

    public static boolean interactWithBlock(Block block, World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return block.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public static EntityList.EntityEggInfo getEggInfo(String name, int colour1, int colour2) {
        return new EntityList.EntityEggInfo(new ResourceLocation(name), colour1, colour2);
    }

    public static IBlockState getBlockStateFromMeta(Block block, int meta) {
        return block.func_176203_a(meta);
    }
}

