/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import thut.essentials.ThutEssentials;
import thut.essentials.economy.EconomyManager;
import thut.essentials.itemcontrol.ItemControl;
import thut.essentials.land.LandEventsHandler;
import thut.essentials.land.LandManager;
import thut.essentials.util.BaseCommand;
import thut.essentials.util.ConfigBase;
import thut.essentials.util.Configure;
import thut.essentials.util.InventoryLogger;
import thut.essentials.util.ServerPauser;
import thut.essentials.util.WarpManager;

public class ConfigManager
extends ConfigBase {
    private static final String SPAWN = "spawn";
    private static final String RULES = "rules";
    private static final String WARPS = "warps";
    private static final String STAFF = "staff";
    private static final String NAMES = "names";
    private static final String COMMANDS = "commands";
    private static final String LAND = "land";
    private static final String ITEM = "itemcontrol";
    private static final String MISC = "misc";
    private static final String ECON = "economy";
    private static final String LOGGING = "logging";
    public static ConfigManager INSTANCE;
    @Configure(category="spawn")
    public int spawnDimension = 0;
    @Configure(category="spawn")
    public boolean spawnDefuzz = false;
    @Configure(category="rules")
    public String[] rules = new String[0];
    @Configure(category="rules")
    public String ruleHeader = "List of Rules:";
    @Configure(category="warps")
    public String[] warps = new String[0];
    @Configure(category="warps")
    public int backReUseDelay = 10;
    @Configure(category="warps")
    public int backRangeCheck = 3;
    @Configure(category="warps")
    public int warpReUseDelay = 10;
    @Configure(category="warps")
    public int spawnReUseDelay = 10;
    @Configure(category="warps")
    public int homeReUseDelay = 10;
    @Configure(category="warps")
    public int backActivateDelay = 10;
    @Configure(category="warps")
    public int warpActivateDelay = 10;
    @Configure(category="warps")
    public int spawnActivateDelay = 10;
    @Configure(category="warps")
    public int homeActivateDelay = 10;
    @Configure(category="warps")
    public int rtpActivateDelay = 10;
    @Configure(category="warps")
    public int tpaActivateDelay = 10;
    @Configure(category="warps")
    public int rtpReuseDelay = 6000;
    @Configure(category="staff")
    public String[] staff = new String[0];
    @Configure(category="itemcontrol")
    public String[] itemBlacklist = new String[0];
    @Configure(category="itemcontrol")
    public boolean itemControlEnabled = false;
    @Configure(category="itemcontrol")
    public double blacklistDamage = 5.0;
    @Configure(category="itemcontrol")
    public int kitReuseDelay = -1;
    @Configure(category="itemcontrol")
    public boolean itemLifeTweak = false;
    @Configure(category="itemcontrol")
    public int itemLifeSpan = 6000;
    @Configure(category="misc")
    public double speedCap = 10.0;
    @Configure(category="misc")
    public int maxHomes = 2;
    @Configure(category="misc")
    public int rtpdistance = 1000;
    @Configure(category="misc")
    public String[] disabledCommands = new String[0];
    @Configure(category="misc")
    public String[] alternateCommands = new String[]{"gamemode:gm"};
    @Configure(category="misc")
    public String[] commandPermissionLevels = new String[]{"heal:2"};
    @Configure(category="misc")
    public String motd = "";
    @Configure(category="misc")
    public boolean comandDisableSpam = false;
    @Configure(category="misc")
    public boolean chatTweaks = true;
    @Configure(category="misc")
    public boolean forceChatFormat = false;
    @Configure(category="misc")
    public String chatFormat = "<[name]> [message]";
    @Configure(category="misc")
    public String[] allThutEssentialsCommands = new String[0];
    @Configure(category="misc")
    public boolean pauseWhenEmpty = false;
    @Configure(category="misc")
    public int pauseTime = 5000;
    @Configure(category="economy")
    public boolean economyEnabled = true;
    @Configure(category="economy")
    public boolean shopsEnabled = true;
    @Configure(category="economy")
    public int maxLandViaSalesPerTeam = 512;
    @Configure(category="names")
    public boolean name = true;
    @Configure(category="names")
    public boolean suffix = true;
    @Configure(category="names")
    public boolean prefix = true;
    @Configure(category="land")
    public boolean landEnabled = false;
    @Configure(category="land")
    public boolean denyExplosions = false;
    @Configure(category="land")
    public int teamLandPerPlayer = 125;
    @Configure(category="land")
    public int playerLand = 1;
    @Configure(category="land")
    public String defaultTeamName = "Plebs";
    @Configure(category="land")
    public String wildernessTeamName = "Wilds";
    @Configure(category="land")
    public boolean wildernessTeam = false;
    @Configure(category="land")
    public boolean logTeamChat = false;
    @Configure(category="land")
    public int prefixLength = 10;
    @Configure(category="land")
    public String[] itemUseWhitelist = new String[0];
    @Configure(category="land")
    public String[] blockUseWhitelist = new String[0];
    @Configure(category="land")
    public String[] blockBreakWhitelist = new String[0];
    @Configure(category="land")
    public String[] blockPlaceWhitelist = new String[0];
    @Configure(category="land")
    public boolean chunkLoading = false;
    @Configure(category="land")
    public int loadedChunksPerTeam = 1;
    @Configure(category="land")
    public boolean defaultMessages = true;
    @Configure(category="commands")
    public String[] commands = new String[0];
    @Configure(category="commands")
    public String[] serverInitCommands = new String[0];
    @Configure(category="logging")
    public boolean debug = false;
    @Configure(category="logging")
    public boolean log_interactions = true;
    @Configure(category="logging")
    public boolean log_teleports = true;
    @Configure(category="logging")
    public boolean log_inventories = true;
    @Configure(category="logging")
    public String[] inventory_log_blacklist = new String[0];

    public ConfigManager() {
        super(null);
    }

    public ConfigManager(File configFile) {
        super(configFile, new ConfigManager());
        MinecraftForge.EVENT_BUS.register((Object)this);
        INSTANCE = this;
        this.populateSettings();
        this.applySettings();
        this.save();
    }

    @Override
    public void applySettings() {
        WarpManager.init();
        if (this.itemControlEnabled) {
            ItemControl.init();
        }
        if (this.landEnabled) {
            LandEventsHandler.init();
        } else {
            LandManager.clearInstance();
        }
        if (this.economyEnabled && ThutEssentials.instance.loaded) {
            EconomyManager.getInstance();
        } else {
            EconomyManager.clearInstance();
        }
        if (this.spawnDefuzz) {
            MinecraftForge.EVENT_BUS.register((Object)ThutEssentials.instance.defuz);
        } else {
            MinecraftForge.EVENT_BUS.unregister((Object)ThutEssentials.instance.defuz);
        }
        if (this.log_inventories) {
            InventoryLogger.enable();
        } else {
            InventoryLogger.disable();
        }
        BaseCommand.permsMap.clear();
        for (String s : this.commandPermissionLevels) {
            try {
                String[] args = s.split(":");
                String key = args[0];
                int value = Integer.parseInt(args[1]);
                BaseCommand.permsMap.put(key, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.pauseWhenEmpty) {
            MinecraftForge.EVENT_BUS.register(ServerPauser.class);
        } else {
            MinecraftForge.EVENT_BUS.unregister(ServerPauser.class);
        }
    }
}

