/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.util.ConfigManager;
import thut.essentials.util.PlayerDataHandler;

public class HomeManager {
    public static String[] HOMEPERMS = null;

    public static void registerPerms() {
        if (HOMEPERMS != null) {
            return;
        }
        HOMEPERMS = new String[ConfigManager.INSTANCE.maxHomes];
        for (int i = 0; i < ConfigManager.INSTANCE.maxHomes; ++i) {
            HomeManager.HOMEPERMS[i] = "thutessentials.homes.max." + (i + 1);
            PermissionAPI.registerNode((String)HOMEPERMS[i], (DefaultPermissionLevel)DefaultPermissionLevel.ALL, (String)"Can the player have this many homes (checked when adding a home).");
        }
    }

    public static int[] getHome(EntityPlayer player, String home) {
        NBTTagCompound tag;
        NBTTagCompound homes;
        if (home == null) {
            home = "Home";
        }
        if ((homes = (tag = PlayerDataHandler.getCustomDataTag(player)).func_74775_l("homes")).func_74764_b(home)) {
            return homes.func_74759_k(home);
        }
        return null;
    }

    public static void setHome(EntityPlayer player, String home) {
        NBTTagCompound tag;
        NBTTagCompound homes;
        int num;
        BlockPos pos = player.func_180425_c();
        if (home == null) {
            home = "Home";
        }
        if ((num = (homes = (tag = PlayerDataHandler.getCustomDataTag(player)).func_74775_l("homes")).func_150296_c().size()) >= ConfigManager.INSTANCE.maxHomes) {
            TextComponentString message = new TextComponentString("You may not have more than " + ConfigManager.INSTANCE.maxHomes + " homes!");
            message.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
            player.func_145747_a((ITextComponent)message);
            return;
        }
        String node = HOMEPERMS[num];
        if (!PermissionAPI.hasPermission((EntityPlayer)player, (String)node)) {
            TextComponentString message = new TextComponentString("You may not have another home!");
            message.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
            player.func_145747_a((ITextComponent)message);
            return;
        }
        if (homes.func_74764_b(home)) {
            TextComponentString message = new TextComponentString("Already have " + home + " use /delhome to remove it first!");
            message.func_150256_b().func_150238_a(TextFormatting.DARK_RED);
            player.func_145747_a((ITextComponent)message);
            return;
        }
        int[] loc = new int[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), player.field_71093_bK};
        homes.func_74783_a(home, loc);
        tag.func_74782_a("homes", (NBTBase)homes);
        player.func_145747_a((ITextComponent)new TextComponentString("set " + home));
        PlayerDataHandler.saveCustomData(player);
    }

    public static void removeHome(EntityPlayer player, String home) {
        if (home == null) {
            home = "Home";
        }
        NBTTagCompound tag = PlayerDataHandler.getCustomDataTag(player);
        NBTTagCompound homes = tag.func_74775_l("homes");
        homes.func_82580_o(home);
        tag.func_74782_a("homes", (NBTBase)homes);
        player.func_145747_a((ITextComponent)new TextComponentString("Removed " + home));
        PlayerDataHandler.saveCustomData(player);
    }

    public static void sendHomeList(EntityPlayer player) {
        NBTTagCompound tag = PlayerDataHandler.getCustomDataTag(player);
        NBTTagCompound homes = tag.func_74775_l("homes");
        player.func_145747_a((ITextComponent)new TextComponentString("================"));
        player.func_145747_a((ITextComponent)new TextComponentString("      Homes     "));
        player.func_145747_a((ITextComponent)new TextComponentString("================"));
        for (String s : homes.func_150296_c()) {
            Style style = new Style();
            style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/home " + s));
            player.func_145747_a(new TextComponentString(s).func_150255_a(style));
        }
        player.func_145747_a((ITextComponent)new TextComponentString("================"));
    }
}

