/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import thut.essentials.ThutEssentials;
import thut.essentials.util.ConfigManager;
import thut.essentials.util.Coordinate;

public class InventoryLogger {
    private static Set<String> blacklist = Sets.newHashSet();

    public static void enable() {
        blacklist = Sets.newHashSet((Object[])ConfigManager.INSTANCE.inventory_log_blacklist);
        MinecraftForge.EVENT_BUS.register(InventoryLogger.class);
    }

    public static void disable() {
        blacklist.clear();
        MinecraftForge.EVENT_BUS.unregister(InventoryLogger.class);
    }

    @SubscribeEvent
    public void PlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        Coordinate c = Coordinate.getChunkCoordFromWorldCoord(event.player.func_180425_c(), event.player.field_71093_bK);
        ThutEssentials.logger.log(Level.FINER, c + " log-in " + event.player.func_110124_au() + " " + event.player.func_70005_c_());
    }

    @SubscribeEvent
    public void PlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        Coordinate c = Coordinate.getChunkCoordFromWorldCoord(event.player.func_180425_c(), event.player.field_71093_bK);
        ThutEssentials.logger.log(Level.FINER, c + " log-out " + event.player.func_110124_au() + " " + event.player.func_70005_c_());
    }

    @SubscribeEvent
    public static void openInventory(PlayerContainerEvent.Open event) {
        Coordinate c = Coordinate.getChunkCoordFromWorldCoord(event.getEntityPlayer().func_180425_c(), event.getEntityPlayer().field_71093_bK);
        ThutEssentials.logger.log(Level.FINER, c + " open " + event.getContainer().getClass() + " " + event.getEntityPlayer().func_110124_au() + " " + event.getEntityPlayer().func_70005_c_());
        if (!blacklist.contains(event.getContainer().getClass().getName())) {
            event.getContainer().func_75132_a((IContainerListener)new Listener(event.getEntityPlayer(), event.getContainer()));
        }
    }

    private static class Listener
    implements IContainerListener {
        final EntityPlayer player;
        final List<ItemStack> initialList = Lists.newArrayList();

        public Listener(EntityPlayer player, Container opened) {
            this.player = player;
            this.initialList.addAll((Collection<ItemStack>)opened.field_75153_a);
        }

        public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
        }

        public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
            try {
                while (slotInd >= this.initialList.size()) {
                    this.initialList.add(ItemStack.field_190927_a);
                }
                ItemStack oldStack = this.initialList.get(slotInd);
                IInventory inventory = containerToSend.func_75139_a((int)slotInd).field_75224_c;
                String invName = inventory.func_70005_c_();
                if (oldStack.func_190926_b() && !stack.func_190926_b()) {
                    ThutEssentials.logger.log(Level.FINER, "slot_place " + containerToSend.getClass() + " " + stack + " " + stack.func_82833_r() + ", " + invName + " " + this.player.func_110124_au() + " " + this.player.func_70005_c_());
                } else if (stack.func_190926_b() && !oldStack.func_190926_b()) {
                    ThutEssentials.logger.log(Level.FINER, "slot_take " + containerToSend.getClass() + " " + oldStack + " " + oldStack.func_82833_r() + ", " + invName + " " + this.player.func_110124_au() + " " + this.player.func_70005_c_());
                } else {
                    ThutEssentials.logger.log(Level.FINER, "slot_swap " + containerToSend.getClass() + " " + stack + " " + stack.func_82833_r() + " <-> " + oldStack + " " + oldStack.func_82833_r() + ", " + invName + " " + this.player.func_110124_au() + " " + this.player.func_70005_c_());
                }
                this.initialList.set(slotInd, stack);
            }
            catch (Exception e) {
                ThutEssentials.logger.log(Level.SEVERE, "Blacklisting Errored Inventory:" + containerToSend.getClass(), e);
                blacklist.add(containerToSend.getClass().getName());
                ArrayList temp = Lists.newArrayList((Iterable)blacklist);
                Collections.sort(temp);
                ConfigManager.INSTANCE.inventory_log_blacklist = temp.toArray(new String[0]);
            }
        }

        public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
        }

        public void func_175173_a(Container containerIn, IInventory inventory) {
        }
    }
}

