/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.PermissionAPI;
import thut.essentials.ThutEssentials;
import thut.essentials.util.CompatWrapper;
import thut.essentials.util.ConfigManager;

public class KitManager {
    public static List<ItemStack> kit = Lists.newArrayList();
    public static Map<String, KitSet> kits = Maps.newHashMap();

    public static void init() {
        FileReader reader;
        Unmarshaller unmarshaller;
        JAXBContext jaxbContext;
        File file = new File(ConfigManager.INSTANCE.getConfigFile().getParentFile(), "kits.xml");
        boolean newKits = file.exists();
        QName ident = new QName("name");
        QName cooldown = new QName("cooldown");
        kits.clear();
        kit.clear();
        if (newKits) {
            try {
                Kits database;
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Kits.class});
                unmarshaller = jaxbContext.createUnmarshaller();
                reader = new FileReader(file);
                Object obj = unmarshaller.unmarshal((Reader)reader);
                Kits kits = database = obj instanceof Kits ? (Kits)obj : new Kits();
                if (obj instanceof XMLStarterItems) {
                    database.kits.add((XMLStarterItems)obj);
                }
                reader.close();
                for (XMLStarterItems items : database.kits) {
                    if (items.values.containsKey(ident)) {
                        KitSet set = new KitSet();
                        String name = items.values.get(ident);
                        if (KitManager.kits.containsKey(name)) {
                            ThutEssentials.logger.log(Level.WARNING, "Duplicate kit: " + name);
                        }
                        ArrayList list = Lists.newArrayList();
                        for (Drop drop : items.drops) {
                            ItemStack stack = KitManager.getStackFromDrop(drop);
                            if (stack.func_190926_b()) continue;
                            list.add(stack);
                        }
                        try {
                            set.cooldown = Integer.parseInt(items.values.get(cooldown));
                        }
                        catch (Exception e) {
                            set.cooldown = 0;
                        }
                        IPermissionHandler manager = PermissionAPI.getPermissionHandler();
                        String node = "thutessentials.kit." + name;
                        if (!manager.getRegisteredNodes().contains(node)) {
                            manager.registerNode(node, DefaultPermissionLevel.ALL, "Can get the Kit " + name);
                        }
                        set.stacks = list;
                        KitManager.kits.put(name, set);
                        continue;
                    }
                    IPermissionHandler manager = PermissionAPI.getPermissionHandler();
                    String node = "thutessentials.kit.default";
                    if (!manager.getRegisteredNodes().contains(node)) {
                        manager.registerNode(node, DefaultPermissionLevel.ALL, "Can get the default Kit");
                    }
                    for (Drop drop : items.drops) {
                        ItemStack stack = KitManager.getStackFromDrop(drop);
                        if (stack.func_190926_b()) continue;
                        kit.add(stack);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            file = new File(ConfigManager.INSTANCE.getConfigFile().getParentFile(), "kit.xml");
            if (file.exists()) {
                newKits = true;
                try {
                    jaxbContext = JAXBContext.newInstance((Class[])new Class[]{XMLStarterItems.class});
                    unmarshaller = jaxbContext.createUnmarshaller();
                    reader = new FileReader(file);
                    XMLStarterItems database = (XMLStarterItems)unmarshaller.unmarshal((Reader)reader);
                    reader.close();
                    for (Drop drop : database.drops) {
                        ItemStack stack = KitManager.getStackFromDrop(drop);
                        if (stack.func_190926_b()) continue;
                        kit.add(stack);
                    }
                    file.delete();
                    file = new File(ConfigManager.INSTANCE.getConfigFile().getParentFile(), "kits.xml");
                    Kits kits = new Kits();
                    kits.kits.add(database);
                    try {
                        jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Kits.class});
                        Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                        jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
                        jaxbMarshaller.marshal((Object)kits, file);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (!newKits) {
            file = new File(ConfigManager.INSTANCE.getConfigFile().getParentFile(), "kits.xml");
            XMLStarterItems items = new XMLStarterItems();
            Drop init = new Drop();
            init.values.put(new QName("id"), "minecraft:stick");
            init.values.put(new QName("n"), "5");
            items.drops.add(init);
            try {
                JAXBContext jaxbContext2 = JAXBContext.newInstance((Class[])new Class[]{XMLStarterItems.class});
                Marshaller jaxbMarshaller = jaxbContext2.createMarshaller();
                jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
                jaxbMarshaller.marshal((Object)items, file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static ItemStack getStackFromDrop(Drop d) {
        Map<QName, String> values = d.values;
        if (d.tag != null) {
            QName name = new QName("tag");
            values.put(name, d.tag);
        }
        return KitManager.getStack(d.values);
    }

    public static boolean isSameStack(ItemStack a, ItemStack b) {
        NBTBase tag;
        boolean check;
        if (!CompatWrapper.isValid(a) || !CompatWrapper.isValid(b)) {
            return false;
        }
        int[] aID = OreDictionary.getOreIDs((ItemStack)a);
        int[] bID = OreDictionary.getOreIDs((ItemStack)b);
        boolean bl = check = a.func_77973_b() == b.func_77973_b();
        if (!check) {
            block0: for (int i : aID) {
                for (int i1 : bID) {
                    if (i != i1) continue;
                    check = true;
                    break block0;
                }
            }
        }
        if (!check) {
            return false;
        }
        boolean bl2 = check = !a.func_77984_f() && a.func_77952_i() != b.func_77952_i();
        if (!(a.func_77984_f() || a.func_77952_i() != Short.MAX_VALUE && b.func_77952_i() != Short.MAX_VALUE)) {
            check = false;
        }
        if (check) {
            return false;
        }
        if (a.func_77942_o() && (tag = a.func_77978_p().func_74781_a("ForgeCaps")) != null && tag.func_82582_d()) {
            a.func_77978_p().func_82580_o("ForgeCaps");
        }
        if (b.func_77942_o() && (tag = b.func_77978_p().func_74781_a("ForgeCaps")) != null && tag.func_82582_d()) {
            b.func_77978_p().func_82580_o("ForgeCaps");
        }
        return ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    public static ItemStack getStack(Map<QName, String> values) {
        int meta = -1;
        String id = "";
        int size = 1;
        boolean resource = false;
        String tag = "";
        for (QName key : values.keySet()) {
            if (key.toString().equals("id")) {
                id = values.get(key);
                continue;
            }
            if (key.toString().equals("d")) {
                meta = Integer.parseInt(values.get(key));
                continue;
            }
            if (key.toString().equals("n")) {
                size = Integer.parseInt(values.get(key));
                continue;
            }
            if (!key.toString().equals("tag")) continue;
            tag = values.get(key);
        }
        if (id.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        resource = id.contains(":");
        ItemStack stack = ItemStack.field_190927_a;
        Item item = null;
        item = resource ? (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(id)) : (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("minecraft:" + id));
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        if (meta == -1) {
            meta = 0;
        }
        if (!CompatWrapper.isValid(stack)) {
            stack = new ItemStack(item, 1, meta);
        }
        CompatWrapper.setStackSize(stack, size);
        if (!tag.isEmpty()) {
            try {
                stack.func_77982_d(JsonToNBT.func_180713_a((String)tag));
            }
            catch (NBTException e) {
                e.printStackTrace();
            }
        }
        return stack;
    }

    @XmlRootElement(name="Drop")
    public static class Drop {
        @XmlAnyAttribute
        public Map<QName, String> values = Maps.newHashMap();
        @XmlElement(name="tag")
        public String tag;
    }

    @XmlRootElement(name="Items")
    public static class XMLStarterItems {
        @XmlAnyAttribute
        public Map<QName, String> values = Maps.newHashMap();
        @XmlElement(name="Item")
        private List<Drop> drops = Lists.newArrayList();
    }

    public static class KitSet {
        public Integer cooldown = null;
        public List<ItemStack> stacks = null;
    }

    @XmlRootElement(name="Kits")
    public static class Kits {
        @XmlElement(name="Kit")
        public List<XMLStarterItems> kits = Lists.newArrayList();
    }
}

