/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerDataHandler {
    public static Set<Class<? extends PlayerData>> dataMap = Sets.newHashSet();
    private static PlayerDataHandler INSTANCESERVER;
    private static PlayerDataHandler INSTANCECLIENT;
    private Map<String, PlayerDataManager> data = Maps.newHashMap();

    public static PlayerDataHandler getInstance() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            return INSTANCECLIENT != null ? INSTANCECLIENT : (INSTANCECLIENT = new PlayerDataHandler());
        }
        return INSTANCESERVER != null ? INSTANCESERVER : (INSTANCESERVER = new PlayerDataHandler());
    }

    public static void clear() {
        if (INSTANCECLIENT != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)INSTANCECLIENT);
        }
        if (INSTANCESERVER != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)INSTANCESERVER);
        }
        INSTANCESERVER = null;
        INSTANCECLIENT = null;
    }

    public static void saveAll() {
    }

    public static NBTTagCompound getCustomDataTag(EntityPlayer player) {
        PlayerDataManager manager = PlayerDataHandler.getInstance().getPlayerData(player);
        PlayerCustomData data = manager.getData(PlayerCustomData.class);
        return data.tag;
    }

    public static NBTTagCompound getCustomDataTag(String player) {
        PlayerDataManager manager = PlayerDataHandler.getInstance().getPlayerData(player);
        PlayerCustomData data = manager.getData(PlayerCustomData.class);
        return data.tag;
    }

    public static void saveCustomData(EntityPlayer player) {
        PlayerDataHandler.saveCustomData(player.func_189512_bd());
    }

    public static void saveCustomData(String cachedUniqueIdString) {
        PlayerDataHandler.getInstance().save(cachedUniqueIdString, "thutessentials");
    }

    public static File getFileForUUID(String uuid, String fileName) {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        ISaveHandler saveHandler = world.func_72860_G();
        String seperator = System.getProperty("file.separator");
        File file = saveHandler.func_75758_b(uuid + seperator + fileName);
        File dir = new File(file.getParentFile().getAbsolutePath());
        if (!file.exists()) {
            dir.mkdirs();
        }
        return file;
    }

    public PlayerDataHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public PlayerDataManager getPlayerData(EntityPlayer player) {
        return this.getPlayerData(player.func_189512_bd());
    }

    public PlayerDataManager getPlayerData(UUID uniqueID) {
        return this.getPlayerData(uniqueID.toString());
    }

    public PlayerDataManager getPlayerData(String uuid) {
        PlayerDataManager manager = this.data.get(uuid);
        if (manager == null) {
            manager = this.load(uuid);
        }
        return manager;
    }

    @SubscribeEvent
    public void cleanupOfflineData(WorldEvent.Save event) {
        if (event.getWorld().field_73011_w.getDimension() == 0) {
            HashSet toUnload = Sets.newHashSet();
            for (String uuid : this.data.keySet()) {
                EntityPlayerMP player = event.getWorld().func_73046_m().func_184103_al().func_177451_a(UUID.fromString(uuid));
                if (player != null) continue;
                toUnload.add(uuid);
            }
            for (String s : toUnload) {
                if (!this.data.containsKey(s)) continue;
                this.save(s);
                this.data.put(s, null);
                this.data.remove(s);
            }
        }
    }

    public PlayerDataManager load(String uuid) {
        PlayerDataManager manager = new PlayerDataManager(uuid);
        for (PlayerData data : manager.data.values()) {
            String fileName = data.dataFileName();
            File file = null;
            try {
                file = PlayerDataHandler.getFileForUUID(uuid, fileName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (file == null || !file.exists()) continue;
            try {
                FileInputStream fileinputstream = new FileInputStream(file);
                NBTTagCompound nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                fileinputstream.close();
                data.readFromNBT(nbttagcompound.func_74775_l("Data"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.data.put(uuid, manager);
        return manager;
    }

    public void save(String uuid, String dataType) {
        PlayerDataManager manager = this.data.get(uuid);
        if (manager != null) {
            for (PlayerData data : manager.data.values()) {
                String fileName;
                File file;
                if (!data.getIdentifier().equals(dataType) || (file = PlayerDataHandler.getFileForUUID(uuid, fileName = data.dataFileName())) == null) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                data.writeToNBT(nbttagcompound);
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74782_a("Data", (NBTBase)nbttagcompound);
                try {
                    FileOutputStream fileoutputstream = new FileOutputStream(file);
                    CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound1, (OutputStream)fileoutputstream);
                    fileoutputstream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void save(String uuid) {
        PlayerDataManager manager = this.data.get(uuid);
        if (manager != null) {
            for (PlayerData data : manager.data.values()) {
                String fileName = data.dataFileName();
                File file = PlayerDataHandler.getFileForUUID(uuid, fileName);
                if (file == null) continue;
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                data.writeToNBT(nbttagcompound);
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74782_a("Data", (NBTBase)nbttagcompound);
                try {
                    FileOutputStream fileoutputstream = new FileOutputStream(file);
                    CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound1, (OutputStream)fileoutputstream);
                    fileoutputstream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        dataMap.add(PlayerCustomData.class);
    }

    public static class PlayerDataManager {
        Map<Class<? extends PlayerData>, PlayerData> data = Maps.newHashMap();
        Map<String, PlayerData> idMap = Maps.newHashMap();
        final String uuid;

        public PlayerDataManager(String uuid) {
            this.uuid = uuid;
            for (Class<? extends PlayerData> type : dataMap) {
                try {
                    PlayerData toAdd = type.newInstance();
                    this.data.put(type, toAdd);
                    this.idMap.put(toAdd.getIdentifier(), toAdd);
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }

        public <T extends PlayerData> T getData(Class<T> type) {
            return (T)this.data.get(type);
        }

        public PlayerData getData(String dataType) {
            return this.idMap.get(dataType);
        }
    }

    public static class PlayerCustomData
    extends PlayerData {
        public NBTTagCompound tag = new NBTTagCompound();

        @Override
        public String getIdentifier() {
            return "thutessentials";
        }

        @Override
        public String dataFileName() {
            return "thutEssentials";
        }

        @Override
        public boolean shouldSync() {
            return false;
        }

        @Override
        public void writeToNBT(NBTTagCompound tag) {
            tag.func_74782_a("data", (NBTBase)this.tag);
        }

        @Override
        public void readFromNBT(NBTTagCompound tag) {
            this.tag = tag.func_74775_l("data");
        }
    }

    public static abstract class PlayerData
    implements IPlayerData {
        @Override
        public void readSync(ByteBuf data) {
        }

        @Override
        public void writeSync(ByteBuf data) {
        }
    }

    private static interface IPlayerData {
        public String getIdentifier();

        public String dataFileName();

        public boolean shouldSync();

        public void writeToNBT(NBTTagCompound var1);

        public void readFromNBT(NBTTagCompound var1);

        public void readSync(ByteBuf var1);

        public void writeSync(ByteBuf var1);
    }
}

