/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import thut.essentials.ThutEssentials;
import thut.essentials.util.ConfigManager;

public class RuleManager {
    static final Field rulesField;
    static final Map<String, TextFormatting> charCodeMap;

    public static String format(String rule) {
        boolean done = false;
        int index = 0;
        String arg = "\\n";
        rule = rule.replace(arg, System.getProperty("line.separator"));
        index = rule.indexOf(38, index);
        while (!done && index < rule.length() && index >= 0) {
            try {
                done = !rule.contains("&");
                index = rule.indexOf(38, index);
                if (index < rule.length() - 1 && index >= 0) {
                    if (index > 0 && rule.substring(index - 1, index).equals("\\")) {
                        ++index;
                        continue;
                    }
                    String toReplace = rule.substring(index, index + 2);
                    String num = toReplace.replace("&", "");
                    TextFormatting format = charCodeMap.get(num);
                    if (format != null) {
                        rule = rule.replaceAll(toReplace, format + "");
                        continue;
                    }
                    ++index;
                    continue;
                }
                done = true;
            }
            catch (Exception e) {
                done = true;
                e.printStackTrace();
            }
        }
        return rule;
    }

    public static void addRule(ICommandSender sender, String rule) throws Exception {
        List<String> rulesList = RuleManager.getRules();
        rule = RuleManager.format(rule);
        rulesList.add(rule);
        sender.func_145747_a((ITextComponent)new TextComponentString("Added rule: " + rule));
        ConfigManager.INSTANCE.updateField(rulesField, rulesList.toArray(new String[0]));
    }

    public static void delRule(ICommandSender sender, int rule) throws Exception {
        List<String> rulesList = RuleManager.getRules();
        String r = rulesList.remove(rule);
        sender.func_145747_a((ITextComponent)new TextComponentString("Removed rule: " + r));
        ConfigManager.INSTANCE.updateField(rulesField, rulesList.toArray(new String[0]));
    }

    public static List<String> getRules() {
        return Lists.newArrayList((Object[])ThutEssentials.instance.config.rules);
    }

    static {
        charCodeMap = Maps.newHashMap();
        Field temp = null;
        try {
            temp = ConfigManager.class.getDeclaredField("rules");
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        rulesField = temp;
        try {
            temp = ReflectionHelper.findField(TextFormatting.class, (String[])new String[]{"formattingCode", "field_96329_z", "z"});
            temp.setAccessible(true);
            for (TextFormatting format : TextFormatting.values()) {
                try {
                    char code = temp.getChar(format);
                    charCodeMap.put(code + "", format);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

