/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.command.CommandException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.IPermissionHandler;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.PlayerContext;
import thut.essentials.ThutEssentials;
import thut.essentials.commands.CommandManager;
import thut.essentials.commands.misc.Spawn;
import thut.essentials.util.ConfigManager;
import thut.essentials.util.PlayerDataHandler;

public class WarpManager {
    public static Map<String, int[]> warpLocs;
    static final Field warpsField;

    static void init() {
        warpLocs = Maps.newHashMap();
        for (String s : ConfigManager.INSTANCE.warps) {
            String[] args = s.split(":");
            warpLocs.put(args[0], WarpManager.getInt(args[1]));
        }
        IPermissionHandler manager = PermissionAPI.getPermissionHandler();
        for (String s : warpLocs.keySet()) {
            String node = "thutessentials.warp." + s;
            if (manager.getRegisteredNodes().contains(node)) continue;
            manager.registerNode(node, DefaultPermissionLevel.ALL, "Warp to " + s);
        }
    }

    static int[] getInt(String val) {
        String[] args = val.split(" ");
        int dim = args.length == 4 ? Integer.parseInt(args[3]) : 0;
        return new int[]{Integer.parseInt(args[0]), Integer.parseInt(args[1]), Integer.parseInt(args[2]), dim};
    }

    public static void setWarp(BlockPos center, int dimension, String name) throws Exception {
        ArrayList warps = Lists.newArrayList((Object[])ConfigManager.INSTANCE.warps);
        for (String s : warps) {
            String[] args = s.split(":");
            if (!args[0].equals(s)) continue;
            throw new CommandException("Requested warp already exits, try /delwarp " + name + " to remove it", new Object[0]);
        }
        String warp = name + ":" + center.func_177958_n() + " " + center.func_177956_o() + " " + center.func_177952_p() + " " + dimension;
        warps.add(warp);
        warpLocs.put(name, new int[]{center.func_177958_n(), center.func_177956_o(), center.func_177952_p(), dimension});
        IPermissionHandler manager = PermissionAPI.getPermissionHandler();
        String node = "thutessentials.warp." + name;
        if (!manager.getRegisteredNodes().contains(node)) {
            manager.registerNode(node, DefaultPermissionLevel.ALL, "Warp to " + name);
        }
        ConfigManager.INSTANCE.updateField(warpsField, warps.toArray(new String[0]));
    }

    public static void delWarp(String name) throws Exception {
        ArrayList warps = Lists.newArrayList((Object[])ConfigManager.INSTANCE.warps);
        for (String s : warps) {
            String[] args = s.split(":");
            if (!args[0].equals(name)) continue;
            warps.remove(s);
            warpLocs.remove(name);
            ConfigManager.INSTANCE.updateField(warpsField, warps.toArray(new String[0]));
            return;
        }
        throw new CommandException("Warp " + name + " does not exist", new Object[0]);
    }

    public static int[] getWarp(String name) {
        return warpLocs.get(name);
    }

    public static void sendWarpsList(EntityPlayer player) {
        IPermissionHandler manager = PermissionAPI.getPermissionHandler();
        PlayerContext context = new PlayerContext(player);
        player.func_145747_a((ITextComponent)new TextComponentString("================"));
        player.func_145747_a((ITextComponent)new TextComponentString("      Warps     "));
        player.func_145747_a((ITextComponent)new TextComponentString("================"));
        for (String s : ConfigManager.INSTANCE.warps) {
            String[] args = s.split(":");
            s = args[0];
            if (!manager.hasPermission(player.func_146103_bH(), "thutessentials.warp." + s, (IContext)context)) continue;
            Style style = new Style();
            style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/warp " + s));
            player.func_145747_a(new TextComponentString(s).func_150255_a(style));
        }
        player.func_145747_a((ITextComponent)new TextComponentString("================"));
    }

    public static void attemptWarp(EntityPlayer player, String warpName) throws CommandException {
        long time;
        int[] warp = WarpManager.getWarp(warpName);
        NBTTagCompound tag = PlayerDataHandler.getCustomDataTag(player);
        NBTTagCompound tptag = tag.func_74775_l("tp");
        long last = tptag.func_74763_f("warpDelay");
        if (last > (time = player.func_184102_h().func_71218_a(0).func_82737_E())) {
            player.func_145747_a(CommandManager.makeFormattedComponent("Too Soon between Warp attempt", TextFormatting.RED, false));
            return;
        }
        if (warp != null) {
            IPermissionHandler manager = PermissionAPI.getPermissionHandler();
            PlayerContext context = new PlayerContext(player);
            if (!manager.hasPermission(player.func_146103_bH(), "thutessentials.warp." + warpName, (IContext)context)) {
                throw new CommandException("You may not use this warp.", new Object[0]);
            }
        } else {
            throw new CommandException("Warp " + warpName + " not found.", new Object[0]);
        }
        ITextComponent teleMess = CommandManager.makeFormattedComponent("Warped to " + warpName, TextFormatting.GREEN);
        Spawn.PlayerMover.setMove(player, ThutEssentials.instance.config.warpActivateDelay, warp[3], new BlockPos(warp[0], warp[1], warp[2]), teleMess, Spawn.INTERUPTED);
        tptag.func_74772_a("warpDelay", time + (long)ConfigManager.INSTANCE.warpReUseDelay);
        tag.func_74782_a("tp", (NBTBase)tptag);
        PlayerDataHandler.saveCustomData(player);
    }

    static {
        Field temp = null;
        try {
            temp = ConfigManager.class.getDeclaredField("warps");
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        warpsField = temp;
    }
}

