/*
 * Decompiled with CFR 0.152.
 */
package thut.essentials.world;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import thut.essentials.ThutEssentials;
import thut.essentials.world.WorldServerMulti;

public class WorldManager {
    public static final Gson gson = new GsonBuilder().registerTypeAdapter(QName.class, (Object)new TypeAdapter<QName>(){

        public void write(JsonWriter out, QName value) throws IOException {
            out.value(value.toString());
        }

        public QName read(JsonReader in) throws IOException {
            return new QName(in.nextString());
        }
    }).setPrettyPrinting().create();
    public static String DEFAULTPATH = "./config";
    public static CustomDims dims;

    public static void loadCustomDims(String dimFile) {
        File file = new File(DEFAULTPATH, dimFile);
        if (!file.exists()) {
            ThutEssentials.logger.log(Level.FINER, "No Custom Dimensions file found: " + file + " If you make one, it will allow specifying custom dimensions and worldgen.");
            return;
        }
        try {
            FileInputStream stream = new FileInputStream(file);
            InputStreamReader reader = new InputStreamReader(stream);
            dims = (CustomDims)gson.fromJson((Reader)reader, CustomDims.class);
            ThutEssentials.logger.log(Level.FINER, "Loaded Dims: " + WorldManager.dims.dims);
        }
        catch (Exception e) {
            ThutEssentials.logger.log(Level.WARNING, "Error loading custom Dims from: " + file, e);
        }
    }

    public static void onServerStart(FMLServerStartingEvent event) throws IOException {
        WorldManager.loadCustomDims("thutessentials_dimensions.json");
        if (dims != null) {
            ThutEssentials.logger.log(Level.FINER, "Starting server, Thut Essentials Registering Dimensions");
            for (CustomDim dim : WorldManager.dims.dims) {
                DimensionType type = DimensionType.OVERWORLD;
                if (dim.dim_type != null) {
                    try {
                        type = DimensionType.func_193417_a((String)dim.dim_type);
                    }
                    catch (Exception e) {
                        ThutEssentials.logger.log(Level.WARNING, "Error with dim_type: " + dim.dim_type, e);
                        type = DimensionType.OVERWORLD;
                    }
                }
                WorldManager.initDimension(dim.dimid, dim.world_name, dim.world_type, dim.generator_options, type, dim.seed);
            }
        }
    }

    public static WorldServer initDimension(int dim, String worldName, String worldType, String generatorOptions, Long seed) {
        return WorldManager.initDimension(dim, worldName, worldType, generatorOptions, DimensionType.OVERWORLD, seed);
    }

    public static WorldServer initDimension(int dim, String worldName, String worldType, String generatorOptions, DimensionType dimType, Long seed) {
        WorldServer overworld = DimensionManager.getWorld((int)0);
        if (dimType == null) {
            dimType = DimensionType.OVERWORLD;
            ThutEssentials.logger.log(Level.WARNING, "Dimtype should not be null!");
        }
        if (!DimensionManager.isDimensionRegistered((int)dim)) {
            DimensionManager.registerDimension((int)dim, (DimensionType)dimType);
        } else {
            ThutEssentials.logger.log(Level.FINER, DimensionManager.getProviderType((int)dim) + "");
        }
        WorldServer oldWorld = DimensionManager.getWorld((int)dim);
        if (generatorOptions != null && generatorOptions.isEmpty()) {
            generatorOptions = null;
        }
        WorldInfo old = overworld.func_72912_H();
        WorldSettings settings = new WorldSettings(seed == null ? overworld.func_72905_C() : seed.longValue(), old.func_76077_q(), old.func_76089_r(), old.func_76093_s(), WorldType.func_77130_a((String)worldType));
        settings.func_82750_a(generatorOptions);
        WorldServer newWorld = WorldManager.initDimension(dim, settings, worldName);
        DimensionManager.setWorld((int)dim, (WorldServer)newWorld, (MinecraftServer)FMLCommonHandler.instance().getMinecraftServerInstance());
        if (oldWorld != null && newWorld != null) {
            ThutEssentials.logger.log(Level.FINER, "Replaced " + oldWorld + " with " + newWorld);
        } else if (newWorld != null) {
            ThutEssentials.logger.log(Level.FINER, "Set World " + newWorld);
        } else {
            ThutEssentials.logger.log(Level.WARNING, "Unable to create world " + dim + " " + worldName + " " + worldType + " " + generatorOptions);
        }
        return newWorld;
    }

    public static WorldServer initDimension(int dim, WorldSettings settings, String name) {
        DimensionManager.initDimension((int)dim);
        WorldServer overworld = DimensionManager.getWorld((int)0);
        WorldInfo info = new WorldInfo(settings, name);
        WorldServerMulti newWorld = new WorldServerMulti(overworld.func_73046_m(), overworld.func_72860_G(), info, dim, overworld.field_72984_F);
        return newWorld;
    }

    public static class CustomDim {
        public int dimid;
        public String world_name;
        public String dim_type;
        public String world_type;
        public String generator_options;
        public Long seed;

        public String toString() {
            return this.dimid + " " + this.world_name + " " + this.dim_type + " " + this.world_type + " " + this.generator_options + " " + this.seed;
        }
    }

    public static class CustomDims {
        public List<CustomDim> dims = Lists.newArrayList();
    }
}

