/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.skin.cape.renderer;

import com.google.common.collect.Lists;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.tlauncher.skin.cape.model.DynamicTexture;
import org.tlauncher.skin.cape.model.MinecraftProfileTextureDTO;
import org.tlauncher.skin.cape.model.PreparedTextureData;
import org.tlauncher.skin.cape.model.ProfileTexture;
import org.tlauncher.skin.cape.renderer.texture.FramedTexture;
import org.tlauncher.skin.cape.util.PreparedProfileManager;

public class TextureManager {
    private final Logger LOGGER = LogManager.getLogger(this.getClass());
    private final Map<String, ProfileTexture> textures = new HashMap<String, ProfileTexture>();
    private static long TIME_GUP = 2000L;
    private PreparedProfileManager preparedProfileManager;
    private long updateTime;
    private long last;

    private void cleanOldTextures() {
        if (this.last < System.currentTimeMillis()) {
            long l = System.currentTimeMillis();
            long current = System.currentTimeMillis();
            List<String> removed = this.textures.entrySet().stream().filter(e -> current > ((ProfileTexture)e.getValue()).getTime()).map(Map.Entry::getKey).collect(Collectors.toList());
            removed.remove(Minecraft.func_71410_x().func_110432_I().func_111285_a());
            for (String s : removed) {
                ProfileTexture profileTexture = this.textures.get(s);
                if (Objects.nonNull(profileTexture.getSkin())) {
                    Minecraft.func_71410_x().func_110434_K().func_147645_c(profileTexture.getSkin());
                }
                if (!Objects.nonNull(profileTexture.getCape())) continue;
                for (ResourceLocation resourceLocation : this.textures.get(s).getCape().getFrames()) {
                    Minecraft.func_71410_x().func_110434_K().func_147645_c(resourceLocation);
                }
            }
            removed.forEach(this.textures::remove);
            this.LOGGER.debug(String.format("removed %s , during %s", String.join((CharSequence)",", Lists.newArrayList(removed)), System.currentTimeMillis() - l));
            this.last = System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(1L);
        }
    }

    public boolean isInit(String username, MinecraftProfileTexture.Type type) {
        ProfileTexture p = this.textures.get(username);
        if (Objects.isNull(p)) {
            return false;
        }
        this.updateCache(username);
        switch (type) {
            case SKIN: {
                return true;
            }
            case CAPE: {
                return p.isCapeReady();
            }
        }
        return false;
    }

    private void updateCache(String username) {
        if (this.updateTime < System.currentTimeMillis()) {
            this.updateTime = System.currentTimeMillis() + TIME_GUP;
            ProfileTexture profileTexture = this.textures.get(username);
            if (Objects.nonNull(profileTexture)) {
                this.LOGGER.debug("updated cache value " + username);
                profileTexture.updateTime();
            }
        }
    }

    public void createFramedTextures() {
        long l = System.currentTimeMillis();
        this.cleanOldTextures();
        PreparedTextureData preparedTextureData = this.preparedProfileManager.peek();
        if (Objects.isNull(preparedTextureData)) {
            return;
        }
        String playerName = preparedTextureData.getName();
        ProfileTexture profile = this.textures.get(playerName);
        try {
            MinecraftProfileTextureDTO p;
            Image image = preparedTextureData.getImages().get(MinecraftProfileTexture.Type.CAPE);
            if (Objects.isNull(profile)) {
                profile = new ProfileTexture();
                profile.updateTime();
                this.textures.put(playerName, profile);
                int[] image1 = preparedTextureData.getSkin();
                BufferedImage skin = preparedTextureData.getImages().get(MinecraftProfileTexture.Type.SKIN);
                ResourceLocation resourceLocation = null;
                if (Objects.nonNull(image1)) {
                    resourceLocation = new ResourceLocation(String.format("dynamic/skin_%s", playerName));
                    DynamicTexture textureObject = new DynamicTexture(skin.getWidth(), skin.getHeight(), preparedTextureData.getSkin());
                    Minecraft.func_71410_x().func_110434_K().func_110579_a(resourceLocation, (ITextureObject)textureObject);
                    Map<String, String> map = preparedTextureData.getProfileTextureDTO().get(MinecraftProfileTexture.Type.SKIN).getMetadata();
                    if (Objects.nonNull(map)) {
                        profile.setSkinType(map.get("model"));
                    }
                }
                profile.setSkin(resourceLocation);
                if (Objects.nonNull(image)) {
                    return;
                }
            }
            if (Objects.isNull(p = preparedTextureData.getProfileTextureDTO().get(MinecraftProfileTexture.Type.CAPE)) || preparedTextureData.getCapeFrames().isEmpty()) {
                this.setReady(playerName, profile);
            } else if (Objects.equals(p.isAnimatedCape(), true)) {
                FramedTexture cape = profile.getCape();
                if (Objects.isNull(cape)) {
                    int fps = p.getFps() > 0 ? p.getFps() : 1;
                    cape = new FramedTexture(p.getCapeHeight(), 1000000000L / (long)fps, true);
                    profile.setCape(cape);
                }
                if (!this.fillCape(preparedTextureData, p, p.getCapeWidth(), cape)) {
                    return;
                }
            } else {
                profile.setCape(FramedTexture.createOneFramedTexture(preparedTextureData.getCapeFrames().get(0), p.getCapeWidth(), p.getCapeHeight()));
            }
        }
        catch (Throwable e) {
            this.LOGGER.error((Object)e);
        }
        if (profile.getSkinType() == null) {
            profile.setSkinType("undefined");
        }
        this.setReady(playerName, profile);
        this.preparedProfileManager.poll();
        long t = System.currentTimeMillis() - l;
        if (preparedTextureData.getMaxTimeLoad() < t) {
            preparedTextureData.setMaxTimeLoad(t);
        }
        this.LOGGER.info(String.format("textures %s was added, skin: %s,cape: %s, max waiting: %s ,during : %s ", playerName, Objects.nonNull(profile.getSkin()), Objects.nonNull(profile.getCape()), preparedTextureData.getMaxTimeLoad(), System.currentTimeMillis() - preparedTextureData.getInitTime()));
    }

    private boolean fillCape(PreparedTextureData preparedTextureData, MinecraftProfileTextureDTO p, int width, FramedTexture cape) {
        int size = preparedTextureData.getCapeFrames().size();
        for (int i = 1; i > 0 && cape.getFrames().size() < size; --i) {
            int index = cape.getFrames().size();
            cape.initByOneImage(preparedTextureData.getCapeFrames().get(index), width / 22 * 64, p.getCapeHeight() / 17 * 32);
        }
        return size == cape.getFrames().size();
    }

    private void setReady(String playerName, ProfileTexture profile) {
        profile.setCapeReady(true);
        this.preparedProfileManager.removeByName(playerName);
    }

    public void setPreparedProfileManager(PreparedProfileManager preparedProfileManager) {
        this.preparedProfileManager = preparedProfileManager;
    }

    public ProfileTexture get(String username) {
        return this.textures.get(username);
    }
}

