/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api;

import info.u_team.u_team_core.intern.network.NetworkHandler;
import info.u_team.u_team_core.intern.network.message.MessageSyncedContainer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface ISyncedContainerTileEntity {
    public void getServerSyncContainerData(NBTTagCompound var1);

    @SideOnly(value=Side.CLIENT)
    public void handleFromServerSyncContainerData(NBTTagCompound var1);

    @SideOnly(value=Side.CLIENT)
    public void getClientSyncContainerData(NBTTagCompound var1);

    public void handleFromClientSyncContainerData(NBTTagCompound var1);

    default public void syncServerToClient(EntityPlayerMP player, BlockPos pos) {
        NBTTagCompound compound = new NBTTagCompound();
        this.getClientSyncContainerData(compound);
        this.sendMessageToClient(player, pos, compound);
    }

    @SideOnly(value=Side.CLIENT)
    default public void syncClientToServer(BlockPos pos) {
        NBTTagCompound compound = new NBTTagCompound();
        this.getClientSyncContainerData(compound);
        this.sendMessageToServer(pos, compound);
    }

    default public void sendMessageToClient(EntityPlayerMP player, BlockPos pos, NBTTagCompound compound) {
        NetworkHandler.network.sendTo((IMessage)new MessageSyncedContainer(pos, compound), player);
    }

    @SideOnly(value=Side.CLIENT)
    default public void sendMessageToServer(BlockPos pos, NBTTagCompound compound) {
        NetworkHandler.network.sendToServer((IMessage)new MessageSyncedContainer(pos, compound));
    }
}

