/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.property;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import info.u_team.u_team_core.api.IPropertyList;
import java.util.Collection;
import java.util.Map;
import net.minecraft.block.properties.PropertyHelper;

public class PropertyList<T extends IPropertyList & Comparable<T>>
extends PropertyHelper<T> {
    private final ImmutableSet<T> values;
    private final Map<String, T> map = Maps.newHashMap();

    protected PropertyList(String propertyname, Class<T> clazz, Collection<T> values) {
        super(propertyname, clazz);
        this.values = ImmutableSet.copyOf(values);
        for (IPropertyList value : values) {
            String name = value.getName();
            if (this.map.containsKey(name)) {
                throw new IllegalArgumentException("Multiple values have the same name '" + name + "'");
            }
            this.map.put(name, value);
        }
    }

    public Collection<T> func_177700_c() {
        return this.values;
    }

    public Optional<T> func_185929_b(String value) {
        return Optional.fromNullable(this.map.get(value));
    }

    public String getName(T value) {
        return value.getName();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof PropertyList && super.equals(object)) {
            PropertyList property = (PropertyList)((Object)object);
            return this.values.equals(property.values) && this.map.equals(property.map);
        }
        return false;
    }

    public int hashCode() {
        int i = super.hashCode();
        i = 31 * i + this.values.hashCode();
        i = 31 * i + this.map.hashCode();
        return i;
    }

    public static <T extends IPropertyList & Comparable<T>> PropertyList<T> create(String name, Class<T> clazz, T ... values) {
        return PropertyList.create(name, clazz, Lists.newArrayList((Object[])values));
    }

    public static <T extends IPropertyList & Comparable<T>> PropertyList<T> create(String name, Class<T> clazz, Collection<T> values) {
        return new PropertyList<T>(name, clazz, values);
    }
}

