/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.container;

import info.u_team.useful_backpacks.container.SlotBackpack;
import info.u_team.useful_backpacks.enums.EnumBackPacks;
import info.u_team.useful_backpacks.inventory.InventoryBackPack;
import info.u_team.useful_backpacks.item.ItemBackPack;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;

@ChestContainer
public class ContainerBackPack
extends Container {
    private final IInventory inventory;
    private final EnumBackPacks type;
    private final boolean offhand;

    public ContainerBackPack(IInventory inventory, InventoryPlayer inventoryplayer, EnumBackPacks type, boolean offhand) {
        this.inventory = inventory;
        this.type = type;
        this.offhand = offhand;
        int x_backpackinv = 0;
        int y_backpackinv = 0;
        int x_playerinv = 0;
        int y_playerinv = 0;
        switch (type) {
            case SMALL: {
                x_backpackinv = 44;
                y_backpackinv = 24;
                x_playerinv = 8;
                y_playerinv = 82;
                break;
            }
            case MEDIUM: {
                x_backpackinv = 8;
                y_backpackinv = 24;
                x_playerinv = 8;
                y_playerinv = 136;
                break;
            }
            case LARGE: {
                x_backpackinv = 8;
                y_backpackinv = 24;
                x_playerinv = 44;
                y_playerinv = 190;
            }
        }
        this.drawBackPackInventory(inventory, x_backpackinv, y_backpackinv);
        this.drawPlayerInventory(inventoryplayer, x_playerinv, y_playerinv);
    }

    public void drawBackPackInventory(IInventory inventory, int x_offset, int y_offset) {
        for (int height = 0; height < this.type.getSizeY(); ++height) {
            for (int width = 0; width < this.type.getSizeX(); ++width) {
                this.func_75146_a(new SlotBackpack(inventory, width + height * this.type.getSizeX(), width * 18 + x_offset, height * 18 + y_offset));
            }
        }
    }

    public void drawPlayerInventory(InventoryPlayer inventory, int x_offset, int y_offset) {
        for (int height = 0; height < 4; ++height) {
            for (int width = 0; width < 9; ++width) {
                if (height == 3) {
                    this.func_75146_a(new Slot((IInventory)inventory, width, width * 18 + x_offset, height * 18 + 4 + y_offset));
                    continue;
                }
                this.func_75146_a(new Slot((IInventory)inventory, width + height * 9 + 9, width * 18 + x_offset, height * 18 + y_offset));
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        ItemStack currentItem;
        ItemStack itemStack = currentItem = this.offhand ? player.func_184592_cb() : player.func_184614_ca();
        if (this.inventory instanceof InventoryBackPack) {
            ItemStack stack = ((InventoryBackPack)this.inventory).getStack();
            return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemBackPack && currentItem == stack;
        }
        return currentItem.func_77973_b() instanceof ItemBackPack;
    }

    public void func_75142_b() {
        super.func_75142_b();
        if (this.inventory instanceof InventoryBackPack) {
            ((InventoryBackPack)this.inventory).writeItemStack();
        }
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index < this.type.getCount() ? !this.func_75135_a(itemstack1, this.type.getCount(), this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, this.type.getCount(), false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        Slot tmpSlot = slotId >= 0 && slotId < this.field_75151_b.size() ? (Slot)this.field_75151_b.get(slotId) : null;
        if (tmpSlot != null && tmpSlot.func_75217_a((IInventory)player.field_71071_by, player.field_71071_by.field_70461_c)) {
            return tmpSlot.func_75211_c();
        }
        if (clickTypeIn == ClickType.SWAP) {
            ItemStack currentItem;
            ItemStack stack = player.field_71071_by.func_70301_a(dragType);
            ItemStack itemStack = currentItem = this.offhand ? player.func_184592_cb() : player.func_184614_ca();
            if (!currentItem.func_190926_b() && stack == currentItem) {
                return ItemStack.field_190927_a;
            }
        }
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    @ChestContainer.RowSizeCallback
    @Optional.Method(modid="inventorytweaks")
    public int getRowSize() {
        return this.type.getSizeX();
    }

    @ContainerSectionCallback
    @Optional.Method(modid="inventorytweaks")
    public Map<ContainerSection, List<Slot>> getContainerSections() {
        Object2ObjectOpenHashMap slots = new Object2ObjectOpenHashMap();
        slots.put(ContainerSection.CHEST, this.field_75151_b.subList(0, this.type.getCount()));
        slots.put(ContainerSection.INVENTORY, this.field_75151_b.subList(this.type.getCount(), this.field_75151_b.size()));
        slots.put(ContainerSection.INVENTORY_NOT_HOTBAR, this.field_75151_b.subList(this.type.getCount(), this.field_75151_b.size() - 9));
        slots.put(ContainerSection.INVENTORY_HOTBAR, this.field_75151_b.subList(this.field_75151_b.size() - 8, this.field_75151_b.size()));
        return slots;
    }
}

