/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_backpacks.item;

import info.u_team.u_team_core.item.UItem;
import info.u_team.u_team_core.util.CustomResourceLocation;
import info.u_team.useful_backpacks.UsefulBackpacksMod;
import info.u_team.useful_backpacks.config.ServerConfig;
import info.u_team.useful_backpacks.container.ContainerBackPack;
import info.u_team.useful_backpacks.enums.EnumBackPacks;
import info.u_team.useful_backpacks.init.UsefulBackPacksCreativeTabs;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBackPack
extends UItem {
    public ItemBackPack(String name) {
        super(name, UsefulBackPacksCreativeTabs.tab);
        this.func_77625_d(1);
        this.field_77787_bX = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        for (int i = 0; i < EnumBackPacks.values().length; ++i) {
            this.setModel((Item)this, i, (ResourceLocation)new CustomResourceLocation(this.getRegistryName(), "_" + EnumBackPacks.byMetadata(i).getName()));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (player == null || hand == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
        }
        if (!world.field_72995_K) {
            player.openGui((Object)UsefulBackpacksMod.getInstance(), hand == EnumHand.MAIN_HAND ? 0 : 1, world, 0, 0, 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack);
    }

    public int getColor(ItemStack stack) {
        NBTTagCompound displaytag;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && (displaytag = tag.func_74775_l("display")) != null && displaytag.func_150297_b("color", 3)) {
            return displaytag.func_74762_e("color");
        }
        return 8478784;
    }

    public void setColor(ItemStack stack, int color) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        if (!tag.func_150297_b("display", 10)) {
            tag.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound displaytag = tag.func_74775_l("display");
        displaytag.func_74768_a("color", color);
        stack.func_77982_d(tag);
    }

    public void removeColor(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            return;
        }
        if (!tag.func_150297_b("display", 10)) {
            return;
        }
        NBTTagCompound displaytag = tag.func_74775_l("display");
        displaytag.func_82580_o("color");
    }

    public boolean hasColor(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_150297_b("display", 10) ? tag.func_74775_l("display").func_150297_b("color", 3) : false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < EnumBackPacks.values().length; ++i) {
            ItemStack normalstack = new ItemStack((Item)this, 1, i);
            items.add((Object)normalstack);
        }
        for (EnumDyeColor color : EnumDyeColor.values()) {
            for (int i = 0; i < EnumBackPacks.values().length; ++i) {
                ItemStack dyedstack = new ItemStack((Item)this, 1, i);
                this.setColor(dyedstack, color.func_193350_e());
                items.add((Object)dyedstack);
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        EnumBackPacks type = EnumBackPacks.byMetadata(stack.func_77960_j());
        return "usefulbackpacks:item.backpack." + type.getName();
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        if (ServerConfig.shareAllNBTData) {
            return super.getNBTShareTag(stack);
        }
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound compound = stack.func_77978_p().func_74737_b();
        compound.func_82580_o("Items");
        if (compound.func_82582_d()) {
            return null;
        }
        return compound;
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return !(player.field_71070_bA instanceof ContainerBackPack);
    }
}

