/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.bookmarks;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.config.Config;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.gui.overlay.IIngredientGridSource;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.util.LegacyUtil;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.io.IOUtils;

public class BookmarkList
implements IIngredientGridSource {
    private static final String MARKER_OTHER = "O:";
    private static final String MARKER_STACK = "T:";
    private final List<Object> list = new LinkedList<Object>();
    private final List<IIngredientListElement> ingredientListElements = new LinkedList<IIngredientListElement>();
    private final IngredientRegistry ingredientRegistry;
    private final List<IIngredientGridSource.Listener> listeners = new ArrayList<IIngredientGridSource.Listener>();

    public BookmarkList(IngredientRegistry ingredientRegistry) {
        this.ingredientRegistry = ingredientRegistry;
    }

    public <T> boolean add(T ingredient) {
        T normalized = this.normalize(ingredient);
        if (!this.contains(normalized) && this.addToLists(normalized, Config.isAddingBookmarksToFront())) {
            this.notifyListenersOfChange();
            this.saveBookmarks();
            return true;
        }
        return false;
    }

    protected <T> T normalize(T ingredient) {
        IIngredientHelper<T> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        T copy = LegacyUtil.getIngredientCopy(ingredient, ingredientHelper);
        if (copy instanceof ItemStack) {
            ((ItemStack)copy).func_190920_e(1);
        } else if (copy instanceof FluidStack) {
            ((FluidStack)copy).amount = 1000;
        }
        return copy;
    }

    private boolean contains(Object ingredient) {
        IIngredientHelper<Object> ingredientHelper = this.ingredientRegistry.getIngredientHelper(ingredient);
        for (Object existing : this.list) {
            if (ingredient == existing) {
                return true;
            }
            if (existing == null || existing.getClass() != ingredient.getClass() || !ingredientHelper.getUniqueId(existing).equals(ingredientHelper.getUniqueId(ingredient))) continue;
            return true;
        }
        return false;
    }

    public boolean remove(Object ingredient) {
        int index = 0;
        for (Object existing : this.list) {
            if (ingredient == existing) {
                this.list.remove(index);
                this.ingredientListElements.remove(index);
                this.notifyListenersOfChange();
                this.saveBookmarks();
                return true;
            }
            ++index;
        }
        return false;
    }

    public void saveBookmarks() {
        ArrayList<String> strings = new ArrayList<String>();
        for (IIngredientListElement element : this.ingredientListElements) {
            Object object = element.getIngredient();
            if (object instanceof ItemStack) {
                strings.add(MARKER_STACK + ((ItemStack)object).func_77955_b(new NBTTagCompound()).toString());
                continue;
            }
            strings.add(MARKER_OTHER + BookmarkList.getUid(element));
        }
        File file = Config.getBookmarkFile();
        if (file != null) {
            try (FileWriter writer = new FileWriter(file);){
                IOUtils.writeLines(strings, (String)"\n", (Writer)writer);
            }
            catch (IOException e) {
                Log.get().error("Failed to save bookmarks list to file {}", (Object)file, (Object)e);
            }
        }
    }

    private static <T> String getUid(IIngredientListElement<T> element) {
        IIngredientHelper<T> ingredientHelper = element.getIngredientHelper();
        return ingredientHelper.getUniqueId(element.getIngredient());
    }

    public void loadBookmarks() {
        List ingredientJsonStrings;
        File file = Config.getBookmarkFile();
        if (file == null || !file.exists()) {
            return;
        }
        try {
            FileReader reader = new FileReader(file);
            Object object = null;
            try {
                ingredientJsonStrings = IOUtils.readLines((Reader)reader);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            Log.get().error("Failed to load bookmarks from file {}", (Object)file, (Object)e);
            return;
        }
        ArrayList<IIngredientType> otherIngredientTypes = new ArrayList<IIngredientType>(this.ingredientRegistry.getRegisteredIngredientTypes());
        otherIngredientTypes.remove(VanillaTypes.ITEM);
        this.list.clear();
        this.ingredientListElements.clear();
        for (String ingredientJsonString : ingredientJsonStrings) {
            if (ingredientJsonString.startsWith(MARKER_STACK)) {
                String itemStackAsJson = ingredientJsonString.substring(MARKER_STACK.length());
                try {
                    NBTTagCompound itemStackAsNbt = JsonToNBT.func_180713_a((String)itemStackAsJson);
                    ItemStack itemStack = new ItemStack(itemStackAsNbt);
                    if (!itemStack.func_190926_b()) {
                        ItemStack normalized = this.normalize(itemStack);
                        this.addToLists(normalized, false);
                        continue;
                    }
                    Log.get().warn("Failed to load bookmarked ItemStack from json string, the item no longer exists:\n{}", (Object)itemStackAsJson);
                }
                catch (NBTException e) {
                    Log.get().error("Failed to load bookmarked ItemStack from json string:\n{}", (Object)itemStackAsJson, (Object)e);
                }
                continue;
            }
            if (ingredientJsonString.startsWith(MARKER_OTHER)) {
                String uid = ingredientJsonString.substring(MARKER_OTHER.length());
                Object ingredient = this.getUnknownIngredientByUid(otherIngredientTypes, uid);
                if (ingredient == null) continue;
                Object normalized = this.normalize(ingredient);
                this.addToLists(normalized, false);
                continue;
            }
            Log.get().error("Failed to load unknown bookmarked ingredient:\n{}", (Object)ingredientJsonString);
        }
        this.notifyListenersOfChange();
    }

    @Nullable
    private Object getUnknownIngredientByUid(Collection<IIngredientType> ingredientTypes, String uid) {
        for (IIngredientType ingredientType : ingredientTypes) {
            Object ingredient = this.ingredientRegistry.getIngredientByUid(ingredientType, uid);
            if (ingredient == null) continue;
            return ingredient;
        }
        return null;
    }

    private <T> boolean addToLists(T ingredient, boolean addToFront) {
        IIngredientType<T> ingredientType = this.ingredientRegistry.getIngredientType(ingredient);
        IIngredientListElement<T> element = IngredientListElementFactory.createUnorderedElement(this.ingredientRegistry, ingredientType, ingredient, ForgeModIdHelper.getInstance());
        if (element != null) {
            if (addToFront) {
                this.list.add(0, ingredient);
                this.ingredientListElements.add(0, element);
            } else {
                this.list.add(ingredient);
                this.ingredientListElements.add(element);
            }
            return true;
        }
        return false;
    }

    @Override
    public List<IIngredientListElement> getIngredientList() {
        return this.ingredientListElements;
    }

    @Override
    public int size() {
        return this.ingredientListElements.size();
    }

    public boolean isEmpty() {
        return this.ingredientListElements.isEmpty();
    }

    @Override
    public void addListener(IIngredientGridSource.Listener listener) {
        this.listeners.add(listener);
    }

    private void notifyListenersOfChange() {
        for (IIngredientGridSource.Listener listener : this.listeners) {
            listener.onChange();
        }
    }
}

